/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird.objects;

import com.messagebird.objects.DataCodingType;
import com.messagebird.objects.MClassType;
import com.messagebird.objects.MessageBase;
import com.messagebird.objects.MsgType;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URL;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Message
implements MessageBase,
Serializable {
    private static final long serialVersionUID = -2110297078875657480L;
    private static final String EMPTY = "";
    private String originator;
    private String body;
    private String recipients;
    private MsgType type;
    private String reference;
    private Integer validity;
    private Integer gateway;
    private Map<String, Object> typeDetails;
    private DataCodingType datacoding = DataCodingType.plain;
    private MClassType mclass;
    private Date scheduledDatetime;
    private URL reportUrl;

    public Message(String originator, String body, String recipients) {
        if (recipients == null || recipients.trim().length() == 0) {
            throw new IllegalArgumentException("Recipients must be specified");
        }
        if (body == null || body.trim().length() == 0) {
            throw new IllegalArgumentException("Body must be specified");
        }
        if (originator == null || originator.trim().length() == 0) {
            throw new IllegalArgumentException("Originator must be specified");
        }
        this.recipients = recipients.trim();
        this.originator = originator.trim();
        this.originator = this.originator.substring(0, Math.min(17, this.originator.length()));
        this.body = body.trim();
    }

    public Message(String originator, String body, List<BigInteger> recipients) {
        this(originator, body, Message.receipientsAsCommaSeperated(recipients));
    }

    public static Message createBinarySMS(String originator, String header, String body, String recipients) {
        Message msg = new Message(originator, body, recipients);
        LinkedHashMap<String, Object> binarySMS = new LinkedHashMap<String, Object>(4);
        binarySMS.put("udh", header);
        msg.setTypeDetails(binarySMS);
        msg.setType(MsgType.binary);
        return msg;
    }

    public static Message createBinarySMS(String originator, String header, String body, List<BigInteger> recipients) {
        return Message.createBinarySMS(originator, header, body, Message.receipientsAsCommaSeperated(recipients));
    }

    protected static String receipientsAsCommaSeperated(List<BigInteger> recipients) {
        if (recipients == null) {
            return null;
        }
        if (recipients.size() == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(recipients.size() * 10);
        for (BigInteger s : recipients) {
            sb.append(s.toString()).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String toString() {
        return "Message{originator='" + this.originator + '\'' + ", body='" + this.body + '\'' + ", recipients='" + this.recipients + '\'' + ", type=" + (Object)((Object)this.type) + ", reference='" + this.reference + '\'' + ", validity=" + this.validity + ", gateway=" + this.gateway + ", reportUrl=" + this.reportUrl + ", typeDetails='" + this.typeDetails + '\'' + ", datacoding=" + (Object)((Object)this.datacoding) + ", mclass=" + (Object)((Object)this.mclass) + ", scheduledDatetime=" + this.scheduledDatetime + '}';
    }

    public String getOriginator() {
        return this.originator;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public String getRecipients() {
        return this.recipients;
    }

    public MsgType getType() {
        return this.type;
    }

    public void setType(MsgType type) {
        this.type = type;
        this.mclass = type == MsgType.flash ? MClassType.flash : MClassType.normal;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Integer getValidity() {
        return this.validity;
    }

    public void setValidity(Integer validity) {
        if (validity < 0) {
            throw new IllegalArgumentException("validity must be >= 0");
        }
        this.validity = validity;
    }

    public Integer getGateway() {
        return this.gateway;
    }

    public void setGateway(Integer gateway) {
        this.gateway = gateway;
    }

    public Map<String, Object> getTypeDetails() {
        return this.typeDetails;
    }

    public void setTypeDetails(Map<String, Object> typeDetails) {
        this.typeDetails = typeDetails;
    }

    public DataCodingType getDatacoding() {
        return this.datacoding;
    }

    public void setDatacoding(DataCodingType datacoding) {
        this.datacoding = datacoding;
    }

    public MClassType getMclass() {
        return this.mclass;
    }

    @Override
    public Date getScheduledDatetime() {
        return this.scheduledDatetime;
    }

    public void setScheduledDatetime(Date scheduledDatetime) {
        this.scheduledDatetime = scheduledDatetime;
    }

    public void setPremiumSMS(Object shortcode, Object keyword, Object tariff, Object mid) {
        LinkedHashMap<String, Object> premiumSMSConfig = new LinkedHashMap<String, Object>(4);
        premiumSMSConfig.put("shortcode", shortcode);
        premiumSMSConfig.put("keyword", keyword);
        premiumSMSConfig.put("tariff", tariff);
        premiumSMSConfig.put("mid", mid);
        this.typeDetails = premiumSMSConfig;
        this.type = MsgType.premium;
    }

    public URL getReportUrl() {
        return this.reportUrl;
    }

    public void setReportUrl(URL reportUrl) {
        this.reportUrl = reportUrl;
    }
}

