/*
 * Decompiled with CFR 0.152.
 */
package com.messagebird;

import com.messagebird.MessageBirdService;
import com.messagebird.exceptions.GeneralException;
import com.messagebird.exceptions.NotFoundException;
import com.messagebird.exceptions.UnauthorizedException;
import com.messagebird.objects.Balance;
import com.messagebird.objects.Contact;
import com.messagebird.objects.ContactList;
import com.messagebird.objects.ContactRequest;
import com.messagebird.objects.ErrorReport;
import com.messagebird.objects.Group;
import com.messagebird.objects.GroupList;
import com.messagebird.objects.GroupRequest;
import com.messagebird.objects.Hlr;
import com.messagebird.objects.Lookup;
import com.messagebird.objects.LookupHlr;
import com.messagebird.objects.Message;
import com.messagebird.objects.MessageList;
import com.messagebird.objects.MessageResponse;
import com.messagebird.objects.MsgType;
import com.messagebird.objects.PagedPaging;
import com.messagebird.objects.Verify;
import com.messagebird.objects.VerifyRequest;
import com.messagebird.objects.VoiceMessage;
import com.messagebird.objects.VoiceMessageList;
import com.messagebird.objects.VoiceMessageResponse;
import com.messagebird.objects.conversations.Conversation;
import com.messagebird.objects.conversations.ConversationList;
import com.messagebird.objects.conversations.ConversationMessage;
import com.messagebird.objects.conversations.ConversationMessageList;
import com.messagebird.objects.conversations.ConversationMessageRequest;
import com.messagebird.objects.conversations.ConversationStartRequest;
import com.messagebird.objects.conversations.ConversationStatus;
import com.messagebird.objects.conversations.ConversationWebhook;
import com.messagebird.objects.conversations.ConversationWebhookList;
import com.messagebird.objects.conversations.ConversationWebhookRequest;
import com.messagebird.objects.voicecalls.RecordingResponse;
import com.messagebird.objects.voicecalls.TranscriptionResponse;
import com.messagebird.objects.voicecalls.VoiceCall;
import com.messagebird.objects.voicecalls.VoiceCallLeg;
import com.messagebird.objects.voicecalls.VoiceCallLegResponse;
import com.messagebird.objects.voicecalls.VoiceCallResponse;
import com.messagebird.objects.voicecalls.VoiceCallResponseList;
import com.messagebird.objects.voicecalls.Webhook;
import com.messagebird.objects.voicecalls.WebhookResponseData;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class MessageBirdClient {
    private static final String CONVERSATIONS_BASE_URL = "https://conversations.messagebird.com/v1";
    static final String VOICE_CALLS_BASE_URL = "https://voice.messagebird.com";
    private static String[] supportedLanguages = new String[]{"de-DE", "en-AU", "en-UK", "en-US", "es-ES", "es-LA", "fr-FR", "it-IT", "nl-NL", "pt-BR"};
    private static final String BALANCEPATH = "/balance";
    private static final String CONTACTPATH = "/contacts";
    private static final String GROUPPATH = "/groups";
    private static final String HLRPATH = "/hlr";
    private static final String LOOKUPHLRPATH = "/lookup/%s/hlr";
    private static final String LOOKUPPATH = "/lookup";
    private static final String MESSAGESPATH = "/messages";
    private static final String VERIFYPATH = "/verify";
    private static final String VOICEMESSAGESPATH = "/voicemessages";
    private static final String CONVERSATION_PATH = "/conversations";
    private static final String CONVERSATION_MESSAGE_PATH = "/messages";
    private static final String CONVERSATION_WEBHOOK_PATH = "/webhooks";
    static final String VOICECALLSPATH = "/calls";
    static final String LEGSPATH = "/legs";
    static final String RECORDINGPATH = "/recordings";
    static final String TRANSCRIPTIONPATH = "/transcriptions";
    static final String WEBHOOKS = "/webhooks";
    private static final String VOICELEGS_SUFFIX_PATH = "/legs";
    private MessageBirdService messageBirdService;

    public MessageBirdClient(MessageBirdService messageBirdService) {
        this.messageBirdService = messageBirdService;
    }

    public Balance getBalance() throws GeneralException, UnauthorizedException, NotFoundException {
        return this.messageBirdService.requestByID(BALANCEPATH, "", Balance.class);
    }

    public Hlr getRequestHlr(BigInteger msisdn, String reference) throws GeneralException, UnauthorizedException {
        if (msisdn == null) {
            throw new IllegalArgumentException("msisdn must be specified.");
        }
        if (reference == null) {
            throw new IllegalArgumentException("Reference must be specified.");
        }
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("msisdn", msisdn);
        payload.put("reference", reference);
        return this.messageBirdService.sendPayLoad(HLRPATH, payload, Hlr.class);
    }

    public Hlr getViewHlr(String hlrId) throws GeneralException, UnauthorizedException, NotFoundException {
        if (hlrId == null) {
            throw new IllegalArgumentException("Hrl ID must be specified.");
        }
        return this.messageBirdService.requestByID(HLRPATH, hlrId, Hlr.class);
    }

    public MessageResponse sendMessage(Message message) throws UnauthorizedException, GeneralException {
        return this.messageBirdService.sendPayLoad("/messages", message, MessageResponse.class);
    }

    public MessageResponse sendMessage(String originator, String body, List<BigInteger> recipients) throws UnauthorizedException, GeneralException {
        return this.messageBirdService.sendPayLoad("/messages", new Message(originator, body, recipients), MessageResponse.class);
    }

    public MessageResponse sendMessage(String originator, String body, List<BigInteger> recipients, String reference) throws UnauthorizedException, GeneralException {
        Message message = new Message(originator, body, recipients);
        message.setReference(reference);
        return this.messageBirdService.sendPayLoad("/messages", message, MessageResponse.class);
    }

    public MessageResponse sendFlashMessage(String originator, String body, List<BigInteger> recipients) throws UnauthorizedException, GeneralException {
        Message message = new Message(originator, body, recipients);
        message.setType(MsgType.flash);
        return this.messageBirdService.sendPayLoad("/messages", message, MessageResponse.class);
    }

    public MessageResponse sendFlashMessage(String originator, String body, List<BigInteger> recipients, String reference) throws UnauthorizedException, GeneralException {
        Message message = new Message(originator, body, recipients);
        message.setType(MsgType.flash);
        message.setReference(reference);
        return this.messageBirdService.sendPayLoad("/messages", message, MessageResponse.class);
    }

    public MessageList listMessages(Integer offset, Integer limit) throws UnauthorizedException, GeneralException {
        if (offset != null && offset < 0) {
            throw new IllegalArgumentException("Offset must be > 0");
        }
        if (limit != null && limit < 0) {
            throw new IllegalArgumentException("Limit must be > 0");
        }
        return this.messageBirdService.requestList("/messages", offset, limit, MessageList.class);
    }

    public void deleteMessage(String id) throws UnauthorizedException, GeneralException, NotFoundException {
        if (id == null) {
            throw new IllegalArgumentException("Message ID must be specified.");
        }
        this.messageBirdService.deleteByID("/messages", id);
    }

    public MessageResponse viewMessage(String id) throws UnauthorizedException, GeneralException, NotFoundException {
        if (id == null) {
            throw new IllegalArgumentException("Message ID must be specified.");
        }
        return this.messageBirdService.requestByID("/messages", id, MessageResponse.class);
    }

    public VoiceMessageResponse sendVoiceMessage(VoiceMessage voiceMessage) throws UnauthorizedException, GeneralException {
        return this.messageBirdService.sendPayLoad(VOICEMESSAGESPATH, voiceMessage, VoiceMessageResponse.class);
    }

    public VoiceMessageResponse sendVoiceMessage(String body, List<BigInteger> recipients) throws UnauthorizedException, GeneralException {
        VoiceMessage message = new VoiceMessage(body, recipients);
        return this.messageBirdService.sendPayLoad(VOICEMESSAGESPATH, message, VoiceMessageResponse.class);
    }

    public VoiceMessageResponse sendVoiceMessage(String body, List<BigInteger> recipients, String reference) throws UnauthorizedException, GeneralException {
        VoiceMessage message = new VoiceMessage(body, recipients);
        message.setReference(reference);
        return this.messageBirdService.sendPayLoad(VOICEMESSAGESPATH, message, VoiceMessageResponse.class);
    }

    public void deleteVoiceMessage(String id) throws UnauthorizedException, GeneralException, NotFoundException {
        if (id == null) {
            throw new IllegalArgumentException("Message ID must be specified.");
        }
        this.messageBirdService.deleteByID(VOICEMESSAGESPATH, id);
    }

    public VoiceMessageResponse viewVoiceMessage(String id) throws UnauthorizedException, GeneralException, NotFoundException {
        if (id == null) {
            throw new IllegalArgumentException("Voice Message ID must be specified.");
        }
        return this.messageBirdService.requestByID(VOICEMESSAGESPATH, id, VoiceMessageResponse.class);
    }

    public VoiceMessageList listVoiceMessages(Integer offset, Integer limit) throws UnauthorizedException, GeneralException {
        if (offset != null && offset < 0) {
            throw new IllegalArgumentException("Offset must be > 0");
        }
        if (limit != null && limit < 0) {
            throw new IllegalArgumentException("Limit must be > 0");
        }
        return this.messageBirdService.requestList(VOICEMESSAGESPATH, offset, limit, VoiceMessageList.class);
    }

    public Verify sendVerifyToken(VerifyRequest verifyRequest) throws UnauthorizedException, GeneralException {
        if (verifyRequest == null) {
            throw new IllegalArgumentException("Verify request cannot be null");
        }
        if (verifyRequest.getRecipient() == null || verifyRequest.getRecipient().isEmpty()) {
            throw new IllegalArgumentException("Recipient cannot be empty for verify");
        }
        return this.messageBirdService.sendPayLoad(VERIFYPATH, verifyRequest, Verify.class);
    }

    public Verify sendVerifyToken(String recipient) throws UnauthorizedException, GeneralException {
        if (recipient == null || recipient.isEmpty()) {
            throw new IllegalArgumentException("Recipient cannot be empty for verify");
        }
        VerifyRequest verifyRequest = new VerifyRequest(recipient);
        return this.sendVerifyToken(verifyRequest);
    }

    public Verify verifyToken(String id, String token) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be empty for verify");
        }
        if (token == null || token.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be empty for verify");
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("token", token);
        return this.messageBirdService.requestByID(VERIFYPATH, id, params, Verify.class);
    }

    Verify getVerifyObject(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be empty for verify");
        }
        return this.messageBirdService.requestByID(VERIFYPATH, id, Verify.class);
    }

    public void deleteVerifyObject(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be empty for verify");
        }
        this.messageBirdService.deleteByID(VERIFYPATH, id);
    }

    public Lookup viewLookup(Lookup lookup) throws UnauthorizedException, GeneralException, NotFoundException {
        if (lookup.getPhoneNumber() == null) {
            throw new IllegalArgumentException("PhoneNumber must be specified.");
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        if (lookup.getCountryCode() != null) {
            params.put("countryCode", lookup.getCountryCode());
        }
        return this.messageBirdService.requestByID(LOOKUPPATH, String.valueOf(lookup.getPhoneNumber()), params, Lookup.class);
    }

    public Lookup viewLookup(BigInteger phoneNumber) throws UnauthorizedException, GeneralException, NotFoundException {
        if (phoneNumber == null) {
            throw new IllegalArgumentException("PhoneNumber must be specified.");
        }
        Lookup lookup = new Lookup(phoneNumber);
        return this.viewLookup(lookup);
    }

    public LookupHlr requestLookupHlr(LookupHlr lookupHlr) throws UnauthorizedException, GeneralException {
        if (lookupHlr.getPhoneNumber() == null) {
            throw new IllegalArgumentException("PhoneNumber must be specified.");
        }
        if (lookupHlr.getReference() == null) {
            throw new IllegalArgumentException("Reference must be specified.");
        }
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("phoneNumber", lookupHlr.getPhoneNumber());
        payload.put("reference", lookupHlr.getReference());
        if (lookupHlr.getCountryCode() != null) {
            payload.put("countryCode", lookupHlr.getCountryCode());
        }
        return this.messageBirdService.sendPayLoad(String.format(LOOKUPHLRPATH, lookupHlr.getPhoneNumber()), payload, LookupHlr.class);
    }

    public LookupHlr requestLookupHlr(BigInteger phoneNumber, String reference) throws UnauthorizedException, GeneralException {
        if (phoneNumber == null) {
            throw new IllegalArgumentException("Phonenumber must be specified.");
        }
        if (reference == null) {
            throw new IllegalArgumentException("Reference must be specified.");
        }
        LookupHlr lookupHlr = new LookupHlr();
        lookupHlr.setPhoneNumber(phoneNumber);
        lookupHlr.setReference(reference);
        return this.requestLookupHlr(lookupHlr);
    }

    public LookupHlr viewLookupHlr(LookupHlr lookupHlr) throws UnauthorizedException, GeneralException, NotFoundException {
        if (lookupHlr.getPhoneNumber() == null) {
            throw new IllegalArgumentException("Phonenumber must be specified");
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        if (lookupHlr.getCountryCode() != null) {
            params.put("countryCode", lookupHlr.getCountryCode());
        }
        return this.messageBirdService.requestByID(String.format(LOOKUPHLRPATH, lookupHlr.getPhoneNumber()), "", params, LookupHlr.class);
    }

    public LookupHlr viewLookupHlr(BigInteger phoneNumber) throws UnauthorizedException, GeneralException, NotFoundException {
        if (phoneNumber == null) {
            throw new IllegalArgumentException("phoneNumber must be specified");
        }
        LookupHlr lookupHlr = new LookupHlr();
        lookupHlr.setPhoneNumber(phoneNumber);
        return this.viewLookupHlr(lookupHlr);
    }

    void deleteContact(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Contact ID must be specified.");
        }
        this.messageBirdService.deleteByID(CONTACTPATH, id);
    }

    public ContactList listContacts(int offset, int limit) throws UnauthorizedException, GeneralException {
        return this.messageBirdService.requestList(CONTACTPATH, offset, limit, ContactList.class);
    }

    public ContactList listContacts() throws UnauthorizedException, GeneralException {
        int limit = 20;
        boolean offset = false;
        return this.listContacts(0, 20);
    }

    public Contact sendContact(ContactRequest contactRequest) throws UnauthorizedException, GeneralException {
        return this.messageBirdService.sendPayLoad(CONTACTPATH, contactRequest, Contact.class);
    }

    public Contact updateContact(String id, ContactRequest contactRequest) throws UnauthorizedException, GeneralException {
        if (id == null) {
            throw new IllegalArgumentException("Contact ID must be specified.");
        }
        String request = "/contacts/" + id;
        return this.messageBirdService.sendPayLoad("PATCH", request, contactRequest, Contact.class);
    }

    public Contact viewContact(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Contact ID must be specified.");
        }
        return this.messageBirdService.requestByID(CONTACTPATH, id, Contact.class);
    }

    public void deleteGroup(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Group ID must be specified.");
        }
        this.messageBirdService.deleteByID(GROUPPATH, id);
    }

    public void deleteGroupContact(String groupId, String contactId) throws NotFoundException, GeneralException, UnauthorizedException {
        if (groupId == null) {
            throw new IllegalArgumentException("Group ID must be specified.");
        }
        if (contactId == null) {
            throw new IllegalArgumentException("Contact ID must be specified.");
        }
        String id = String.format("%s%s/%s", groupId, CONTACTPATH, contactId);
        this.messageBirdService.deleteByID(GROUPPATH, id);
    }

    public GroupList listGroups(int offset, int limit) throws UnauthorizedException, GeneralException {
        return this.messageBirdService.requestList(GROUPPATH, offset, limit, GroupList.class);
    }

    public GroupList listGroups() throws UnauthorizedException, GeneralException {
        boolean offset = false;
        int limit = 20;
        return this.listGroups(0, 20);
    }

    public Group sendGroup(GroupRequest groupRequest) throws UnauthorizedException, GeneralException {
        return this.messageBirdService.sendPayLoad(GROUPPATH, groupRequest, Group.class);
    }

    public void sendGroupContact(String groupId, String[] contactIds) throws NotFoundException, GeneralException, UnauthorizedException {
        String path = String.format("%s%s?%s", groupId, CONTACTPATH, this.getQueryString(contactIds));
        this.messageBirdService.requestByID(GROUPPATH, path, null);
    }

    private String getQueryString(String[] contactIds) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("_method=PUT");
        for (String groupId : contactIds) {
            stringBuilder.append("&ids[]=").append(groupId);
        }
        return stringBuilder.toString();
    }

    public Group updateGroup(String id, GroupRequest groupRequest) throws UnauthorizedException, GeneralException {
        if (id == null) {
            throw new IllegalArgumentException("Group ID must be specified.");
        }
        String path = String.format("%s/%s", GROUPPATH, id);
        return this.messageBirdService.sendPayLoad("PATCH", path, groupRequest, Group.class);
    }

    public Group viewGroup(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Group ID must be specified.");
        }
        return this.messageBirdService.requestByID(GROUPPATH, id, Group.class);
    }

    public Conversation viewConversation(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Id must be specified");
        }
        String url = "https://conversations.messagebird.com/v1/conversations";
        return this.messageBirdService.requestByID(url, id, Conversation.class);
    }

    public Conversation updateConversation(String id, ConversationStatus status) throws UnauthorizedException, GeneralException {
        if (id == null) {
            throw new IllegalArgumentException("Id must be specified.");
        }
        String url = String.format("%s%s/%s", CONVERSATIONS_BASE_URL, CONVERSATION_PATH, id);
        return this.messageBirdService.sendPayLoad("PATCH", url, status, Conversation.class);
    }

    public ConversationList listConversations(int offset, int limit) throws UnauthorizedException, GeneralException {
        String url = "https://conversations.messagebird.com/v1/conversations";
        return this.messageBirdService.requestList(url, offset, limit, ConversationList.class);
    }

    public ConversationList listConversations() throws UnauthorizedException, GeneralException {
        boolean offset = false;
        int limit = 10;
        return this.listConversations(0, 10);
    }

    public Conversation startConversation(ConversationStartRequest request) throws UnauthorizedException, GeneralException {
        String url = String.format("%s%s/start", CONVERSATIONS_BASE_URL, CONVERSATION_PATH);
        return this.messageBirdService.sendPayLoad(url, request, Conversation.class);
    }

    public ConversationMessageList listConversationMessages(String conversationId, int offset, int limit) throws UnauthorizedException, GeneralException {
        String url = String.format("%s%s/%s%s", CONVERSATIONS_BASE_URL, CONVERSATION_PATH, conversationId, "/messages");
        return this.messageBirdService.requestList(url, offset, limit, ConversationMessageList.class);
    }

    public ConversationMessageList listConversationMessages(String conversationId) throws UnauthorizedException, GeneralException {
        boolean offset = false;
        int limit = 10;
        return this.listConversationMessages(conversationId, 0, 10);
    }

    public ConversationMessage viewConversationMessage(String messageId) throws NotFoundException, GeneralException, UnauthorizedException {
        String url = "https://conversations.messagebird.com/v1/messages";
        return this.messageBirdService.requestByID(url, messageId, ConversationMessage.class);
    }

    public ConversationMessage sendConversationMessage(String conversationId, ConversationMessageRequest request) throws UnauthorizedException, GeneralException {
        String url = String.format("%s%s/%s%s", CONVERSATIONS_BASE_URL, CONVERSATION_PATH, conversationId, "/messages");
        return this.messageBirdService.sendPayLoad(url, request, ConversationMessage.class);
    }

    public void deleteConversationWebhook(String webhookId) throws NotFoundException, GeneralException, UnauthorizedException {
        String url = "https://conversations.messagebird.com/v1/webhooks";
        this.messageBirdService.deleteByID(url, webhookId);
    }

    public ConversationWebhook sendConversationWebhook(ConversationWebhookRequest request) throws UnauthorizedException, GeneralException {
        String url = "https://conversations.messagebird.com/v1/webhooks";
        return this.messageBirdService.sendPayLoad(url, request, ConversationWebhook.class);
    }

    public ConversationWebhook viewConversationWebhook(String webhookId) throws NotFoundException, GeneralException, UnauthorizedException {
        String url = "https://conversations.messagebird.com/v1/webhooks";
        return this.messageBirdService.requestByID(url, webhookId, ConversationWebhook.class);
    }

    ConversationWebhookList listConversationWebhooks(int offset, int limit) throws UnauthorizedException, GeneralException {
        String url = "https://conversations.messagebird.com/v1/webhooks";
        return this.messageBirdService.requestList(url, offset, limit, ConversationWebhookList.class);
    }

    public ConversationWebhookList listConversationWebHooks() throws UnauthorizedException, GeneralException {
        boolean offset = false;
        int limit = 10;
        return this.listConversationWebhooks(0, 10);
    }

    public VoiceCallResponse sendVoiceCall(VoiceCall voiceCall) throws UnauthorizedException, GeneralException {
        if (voiceCall.getSource() == null) {
            throw new IllegalArgumentException("Source of voice call must be specified.");
        }
        if (voiceCall.getDestination() == null) {
            throw new IllegalArgumentException("Destination of voice call must be specified.");
        }
        if (voiceCall.getCallFlow() == null) {
            throw new IllegalArgumentException("Call flow of voice call must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH);
        return this.messageBirdService.sendPayLoad(url, voiceCall, VoiceCallResponse.class);
    }

    public VoiceCallResponseList listAllVoiceCalls(Integer page, Integer pageSize) throws GeneralException, UnauthorizedException {
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH);
        return this.messageBirdService.requestList(url, new PagedPaging(page, pageSize), VoiceCallResponseList.class);
    }

    public VoiceCallResponse viewVoiceCall(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Voice Message ID must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH);
        return this.messageBirdService.requestByID(url, id, VoiceCallResponse.class);
    }

    public void deleteVoiceCall(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Voice Message ID must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH);
        this.messageBirdService.deleteByID(url, id);
    }

    public VoiceCallLegResponse viewCallLegsByCallId(String callId, Integer page, Integer pageSize) throws UnsupportedEncodingException, UnauthorizedException, GeneralException {
        if (callId == null) {
            throw new IllegalArgumentException("Voice call ID must be specified.");
        }
        String url = String.format("%s%s/%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH, this.urlEncode(callId), "/legs");
        return this.messageBirdService.requestList(url, new PagedPaging(page, pageSize), VoiceCallLegResponse.class);
    }

    public VoiceCallLeg viewCallLegByCallIdAndLegId(String callId, String legId) throws UnsupportedEncodingException, NotFoundException, GeneralException, UnauthorizedException {
        if (callId == null) {
            throw new IllegalArgumentException("Voice call ID must be specified.");
        }
        if (legId == null) {
            throw new IllegalArgumentException("Leg ID must be specified.");
        }
        String url = String.format("%s%s/%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH, this.urlEncode(callId), "/legs");
        VoiceCallLegResponse response = this.messageBirdService.requestByID(url, legId, VoiceCallLegResponse.class);
        if (response.getData().size() == 1) {
            return response.getData().get(0);
        }
        throw new NotFoundException("No such leg", new LinkedList<ErrorReport>());
    }

    private String urlEncode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, String.valueOf(StandardCharsets.UTF_8));
    }

    public RecordingResponse viewRecording(String callID, String legId, String recordingId) throws NotFoundException, GeneralException, UnauthorizedException {
        if (callID == null) {
            throw new IllegalArgumentException("Voice call ID must be specified.");
        }
        if (legId == null) {
            throw new IllegalArgumentException("Leg ID must be specified.");
        }
        if (recordingId == null) {
            throw new IllegalArgumentException("Recording ID must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("legs", legId);
        params.put("recordings", recordingId);
        return this.messageBirdService.requestByID(url, callID, params, RecordingResponse.class);
    }

    public TranscriptionResponse createTranscription(String callID, String legId, String recordingId, String language) throws UnauthorizedException, GeneralException {
        if (callID == null) {
            throw new IllegalArgumentException("Voice call ID must be specified.");
        }
        if (legId == null) {
            throw new IllegalArgumentException("Leg ID must be specified.");
        }
        if (recordingId == null) {
            throw new IllegalArgumentException("Recording ID must be specified.");
        }
        if (language == null) {
            throw new IllegalArgumentException("Language must be specified.");
        }
        if (!Arrays.asList(supportedLanguages).contains(language)) {
            throw new IllegalArgumentException("Your language is not allowed.");
        }
        String url = String.format("%s%s/%s%s/%s%s/%s%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH, callID, "/legs", legId, RECORDINGPATH, recordingId, TRANSCRIPTIONPATH);
        return this.messageBirdService.sendPayLoad(url, language, TranscriptionResponse.class);
    }

    public TranscriptionResponse viewTranscription(String callID, String legId, String recordingId, Integer page, Integer pageSize) throws UnauthorizedException, GeneralException {
        if (callID == null) {
            throw new IllegalArgumentException("Voice call ID must be specified.");
        }
        if (legId == null) {
            throw new IllegalArgumentException("Leg ID must be specified.");
        }
        if (recordingId == null) {
            throw new IllegalArgumentException("Recording ID must be specified.");
        }
        String url = String.format("%s%s/%s%s/%s%s/%s", VOICE_CALLS_BASE_URL, VOICECALLSPATH, callID, "/legs", legId, RECORDINGPATH, recordingId);
        return this.messageBirdService.requestList(url, new PagedPaging(page, pageSize), TranscriptionResponse.class);
    }

    public WebhookResponseData createWebHook(Webhook webhook) throws UnauthorizedException, GeneralException {
        if (webhook.getTitle() == null) {
            throw new IllegalArgumentException("Title of webhook must be specified.");
        }
        if (webhook.getUrl() == null) {
            throw new IllegalArgumentException("URL of webhook must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, "/webhooks");
        return this.messageBirdService.sendPayLoad(url, webhook, WebhookResponseData.class);
    }

    public WebhookResponseData viewWebHook(String id) throws NotFoundException, GeneralException, UnauthorizedException {
        if (id == null) {
            throw new IllegalArgumentException("Id of webHook must be specified.");
        }
        String url = String.format("%s%s", VOICE_CALLS_BASE_URL, "/webhooks");
        return this.messageBirdService.requestByID(url, id, WebhookResponseData.class);
    }
}

