/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.net;

import com.google.gson.JsonObject;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.net.HttpMethod;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class MPRequest {
    private final String uri;
    private final HttpMethod method;
    private final Map<String, String> headers;
    private final JsonObject payload;
    private final Map<String, Object> queryParams;
    private final String accessToken;
    private final int connectionTimeout;
    private final int connectionRequestTimeout;
    private final int socketTimeout;

    public static MPRequest buildRequest(String path, HttpMethod method, JsonObject payload, Map<String, Object> queryParams, MPRequestOptions requestOptions) {
        MPRequest mpRequest = Objects.nonNull(requestOptions) ? MPRequest.builder().uri(path).method(method).headers(requestOptions.getCustomHeaders()).payload(payload).queryParams(queryParams).accessToken(requestOptions.getAccessToken()).connectionRequestTimeout(requestOptions.getConnectionRequestTimeout()).connectionTimeout(requestOptions.getConnectionTimeout()).socketTimeout(requestOptions.getSocketTimeout()).build() : MPRequest.builder().uri(path).method(method).payload(payload).build();
        return mpRequest;
    }

    public String createIdempotencyKey() {
        return UUID.randomUUID().toString();
    }

    MPRequest(String uri, HttpMethod method, Map<String, String> headers, JsonObject payload, Map<String, Object> queryParams, String accessToken, int connectionTimeout, int connectionRequestTimeout, int socketTimeout) {
        this.uri = uri;
        this.method = method;
        this.headers = headers;
        this.payload = payload;
        this.queryParams = queryParams;
        this.accessToken = accessToken;
        this.connectionTimeout = connectionTimeout;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.socketTimeout = socketTimeout;
    }

    public static MPRequestBuilder builder() {
        return new MPRequestBuilder();
    }

    public String getUri() {
        return this.uri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public JsonObject getPayload() {
        return this.payload;
    }

    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public static class MPRequestBuilder {
        private String uri;
        private HttpMethod method;
        private Map<String, String> headers;
        private JsonObject payload;
        private Map<String, Object> queryParams;
        private String accessToken;
        private int connectionTimeout;
        private int connectionRequestTimeout;
        private int socketTimeout;

        MPRequestBuilder() {
        }

        public MPRequestBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public MPRequestBuilder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public MPRequestBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public MPRequestBuilder payload(JsonObject payload) {
            this.payload = payload;
            return this;
        }

        public MPRequestBuilder queryParams(Map<String, Object> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public MPRequestBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public MPRequestBuilder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public MPRequestBuilder connectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public MPRequestBuilder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public MPRequest build() {
            return new MPRequest(this.uri, this.method, this.headers, this.payload, this.queryParams, this.accessToken, this.connectionTimeout, this.connectionRequestTimeout, this.socketTimeout);
        }

        public String toString() {
            return "MPRequest.MPRequestBuilder(uri=" + this.uri + ", method=" + (Object)((Object)this.method) + ", headers=" + this.headers + ", payload=" + this.payload + ", queryParams=" + this.queryParams + ", accessToken=" + this.accessToken + ", connectionTimeout=" + this.connectionTimeout + ", connectionRequestTimeout=" + this.connectionRequestTimeout + ", socketTimeout=" + this.socketTimeout + ")";
        }
    }
}

