/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.oauth;

import com.mercadopago.MercadoPagoConfig;
import com.mercadopago.client.MercadoPagoClient;
import com.mercadopago.client.oauth.CreateOauthCredentialRequest;
import com.mercadopago.client.oauth.RefreshOauthCredentialRequest;
import com.mercadopago.client.user.UserClient;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.exceptions.MPApiException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPHttpClient;
import com.mercadopago.net.MPRequest;
import com.mercadopago.net.MPResponse;
import com.mercadopago.net.UrlFormatter;
import com.mercadopago.resources.oauth.CreateOauthCredential;
import com.mercadopago.resources.oauth.RefreshOauthCredential;
import com.mercadopago.resources.user.User;
import com.mercadopago.serialization.Serializer;
import java.util.HashMap;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class OauthClient
extends MercadoPagoClient {
    private static final Logger LOGGER = Logger.getLogger(OauthClient.class.getName());
    private final UserClient userClient;
    private final String authHost = "https://auth.mercadopago.com";
    private final String path = "/oauth/token";

    public OauthClient() {
        this(MercadoPagoConfig.getHttpClient());
        StreamHandler streamHandler = MercadoPagoConfig.getStreamHandler();
        streamHandler.setLevel(MercadoPagoConfig.getLoggingLevel());
        LOGGER.addHandler(streamHandler);
        LOGGER.setLevel(MercadoPagoConfig.getLoggingLevel());
    }

    public OauthClient(MPHttpClient httpClient) {
        super(httpClient);
        this.userClient = new UserClient(httpClient);
    }

    public String getAuthorizationURL(String appId, String redirectUri) throws MPException, MPApiException {
        return this.getAuthorizationURL(appId, redirectUri, null);
    }

    public String getAuthorizationURL(String appId, String redirectUri, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending get oauth authorization url request");
        User user = this.userClient.get(requestOptions);
        if (Objects.isNull(user) || user.getCountryId().isEmpty()) {
            return null;
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("client_id", appId);
        queryParams.put("response_type", "code");
        queryParams.put("platform_id", "mp");
        queryParams.put("redirect_uri", redirectUri);
        return UrlFormatter.format(String.format("%s.%s/authorization", "https://auth.mercadopago.com", user.getCountryId().toLowerCase()), queryParams);
    }

    public CreateOauthCredential createCredential(String authorizationCode, String redirectUri) throws MPException, MPApiException {
        return this.createCredential(authorizationCode, redirectUri, null);
    }

    public CreateOauthCredential createCredential(String authorizationCode, String redirectUri, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending create oauth credential request");
        CreateOauthCredentialRequest request = CreateOauthCredentialRequest.builder().clientSecret(this.getAccessToken(requestOptions)).code(authorizationCode).redirectUri(redirectUri).build();
        MPRequest mpRequest = MPRequest.buildRequest("/oauth/token", HttpMethod.POST, Serializer.serializeToJson(request), null, requestOptions);
        MPResponse response = this.send(mpRequest);
        CreateOauthCredential credential = Serializer.deserializeFromJson(CreateOauthCredential.class, response.getContent());
        credential.setResponse(response);
        return credential;
    }

    public RefreshOauthCredential refreshCredential(String refreshToken) throws MPException, MPApiException {
        return this.refreshCredential(refreshToken, null);
    }

    public RefreshOauthCredential refreshCredential(String refreshToken, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending refresh oauth credential request");
        RefreshOauthCredentialRequest request = RefreshOauthCredentialRequest.builder().clientSecret(this.getAccessToken(requestOptions)).refreshToken(refreshToken).build();
        MPRequest mpRequest = MPRequest.buildRequest("/oauth/token", HttpMethod.POST, Serializer.serializeToJson(request), null, requestOptions);
        MPResponse response = this.send(mpRequest);
        RefreshOauthCredential credential = Serializer.deserializeFromJson(RefreshOauthCredential.class, response.getContent());
        credential.setResponse(response);
        return credential;
    }

    private String getAccessToken(MPRequestOptions requestOptions) {
        return Objects.isNull(requestOptions) ? MercadoPagoConfig.getAccessToken() : requestOptions.getAccessToken();
    }
}

