/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.customer;

import com.mercadopago.client.common.IdentificationRequest;
import com.mercadopago.client.common.PhoneRequest;
import com.mercadopago.client.customer.CustomerAddressRequest;
import java.time.OffsetDateTime;
import java.util.Map;

public class CustomerRequest {
    private final String email;
    private final String firstName;
    private final String lastName;
    private final PhoneRequest phone;
    private final IdentificationRequest identification;
    private final String defaultAddress;
    private final CustomerAddressRequest address;
    private final String defaultCard;
    private final OffsetDateTime dateRegistred;
    private final String description;
    private final Map<String, Object> metadata;

    CustomerRequest(String email, String firstName, String lastName, PhoneRequest phone, IdentificationRequest identification, String defaultAddress, CustomerAddressRequest address, String defaultCard, OffsetDateTime dateRegistred, String description, Map<String, Object> metadata) {
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
        this.phone = phone;
        this.identification = identification;
        this.defaultAddress = defaultAddress;
        this.address = address;
        this.defaultCard = defaultCard;
        this.dateRegistred = dateRegistred;
        this.description = description;
        this.metadata = metadata;
    }

    public static CustomerRequestBuilder builder() {
        return new CustomerRequestBuilder();
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public PhoneRequest getPhone() {
        return this.phone;
    }

    public IdentificationRequest getIdentification() {
        return this.identification;
    }

    public String getDefaultAddress() {
        return this.defaultAddress;
    }

    public CustomerAddressRequest getAddress() {
        return this.address;
    }

    public String getDefaultCard() {
        return this.defaultCard;
    }

    public OffsetDateTime getDateRegistred() {
        return this.dateRegistred;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public static class CustomerRequestBuilder {
        private String email;
        private String firstName;
        private String lastName;
        private PhoneRequest phone;
        private IdentificationRequest identification;
        private String defaultAddress;
        private CustomerAddressRequest address;
        private String defaultCard;
        private OffsetDateTime dateRegistred;
        private String description;
        private Map<String, Object> metadata;

        CustomerRequestBuilder() {
        }

        public CustomerRequestBuilder email(String email) {
            this.email = email;
            return this;
        }

        public CustomerRequestBuilder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public CustomerRequestBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public CustomerRequestBuilder phone(PhoneRequest phone) {
            this.phone = phone;
            return this;
        }

        public CustomerRequestBuilder identification(IdentificationRequest identification) {
            this.identification = identification;
            return this;
        }

        public CustomerRequestBuilder defaultAddress(String defaultAddress) {
            this.defaultAddress = defaultAddress;
            return this;
        }

        public CustomerRequestBuilder address(CustomerAddressRequest address) {
            this.address = address;
            return this;
        }

        public CustomerRequestBuilder defaultCard(String defaultCard) {
            this.defaultCard = defaultCard;
            return this;
        }

        public CustomerRequestBuilder dateRegistred(OffsetDateTime dateRegistred) {
            this.dateRegistred = dateRegistred;
            return this;
        }

        public CustomerRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public CustomerRequestBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public CustomerRequest build() {
            return new CustomerRequest(this.email, this.firstName, this.lastName, this.phone, this.identification, this.defaultAddress, this.address, this.defaultCard, this.dateRegistred, this.description, this.metadata);
        }

        public String toString() {
            return "CustomerRequest.CustomerRequestBuilder(email=" + this.email + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", phone=" + this.phone + ", identification=" + this.identification + ", defaultAddress=" + this.defaultAddress + ", address=" + this.address + ", defaultCard=" + this.defaultCard + ", dateRegistred=" + this.dateRegistred + ", description=" + this.description + ", metadata=" + this.metadata + ")";
        }
    }
}

