/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.payment;

import com.mercadopago.client.common.IdentificationRequest;

public class PaymentPassengerRequest {
    private final String firstName;
    private final String lastName;
    private final IdentificationRequest identification;

    PaymentPassengerRequest(String firstName, String lastName, IdentificationRequest identification) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.identification = identification;
    }

    public static PaymentPassengerRequestBuilder builder() {
        return new PaymentPassengerRequestBuilder();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public IdentificationRequest getIdentification() {
        return this.identification;
    }

    public static class PaymentPassengerRequestBuilder {
        private String firstName;
        private String lastName;
        private IdentificationRequest identification;

        PaymentPassengerRequestBuilder() {
        }

        public PaymentPassengerRequestBuilder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public PaymentPassengerRequestBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public PaymentPassengerRequestBuilder identification(IdentificationRequest identification) {
            this.identification = identification;
            return this;
        }

        public PaymentPassengerRequest build() {
            return new PaymentPassengerRequest(this.firstName, this.lastName, this.identification);
        }

        public String toString() {
            return "PaymentPassengerRequest.PaymentPassengerRequestBuilder(firstName=" + this.firstName + ", lastName=" + this.lastName + ", identification=" + this.identification + ")";
        }
    }
}

