/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec.util;

public class Strings {
    public static String formatEnum(Enum<?> enumValue) {
        return Strings.capitalizeFirstCharacterLowercaseRest(enumValue.name().replace('_', ' '));
    }

    private static String capitalizeFirstCharacterLowercaseRest(String s) {
        if (!Strings.hasContent(s)) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static boolean hasContent(String s) {
        return Strings.hasContent(s, true);
    }

    public static boolean hasContent(String s, boolean trim) {
        return s != null && !(trim ? s.trim() : s).isEmpty();
    }

    public static String joinObjects(String sep, Iterable<?> l) {
        return Strings.sepList(sep, l, -1);
    }

    public static String sepList(String sep, Iterable<?> os, int max) {
        return Strings.sepList(sep, null, os, max);
    }

    public static String sepList(String sep, String wrap, Iterable<?> os, int max) {
        StringBuilder sb = new StringBuilder();
        String s = "";
        if (max == 0) {
            max = -1;
        }
        for (Object o : os) {
            sb.append(s);
            s = sep;
            if (max-- == 0) {
                sb.append("...");
                break;
            }
            if (wrap != null) {
                sb.append(wrap);
            }
            sb.append(o);
            if (wrap == null) continue;
            sb.append(wrap);
        }
        return sb.toString();
    }
}

