/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.medallia.word2vec.util.AC;
import com.medallia.word2vec.util.Common;
import com.medallia.word2vec.util.NDC;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;

public class ProfilingTimer
implements AC {
    public static volatile boolean enabled = true;
    public static volatile boolean topLevelInfoOnly = true;
    public static final ProfilingTimer NONE = new ProfilingTimer(null, null, null, new Object[0]){

        @Override
        public AC start(String taskName, Object ... args) {
            return AC.NOTHING;
        }

        @Override
        public void end() {
        }

        @Override
        public void close() {
        }
    };
    private final Log log;
    private final ThreadLocal<ProfilingTimerNode> current = new ThreadLocal();
    private final ByteArrayOutputStream serializationOutput;

    public static ProfilingTimer create(Log log, String processName, Object ... args) {
        return ProfilingTimer.create(log, topLevelInfoOnly, null, processName, args);
    }

    public static ProfilingTimer createLoggingSubtasks(Log log, String processName, Object ... args) {
        return ProfilingTimer.create(log, false, null, processName, args);
    }

    public static ProfilingTimer createSubtasksAndSerialization(ByteArrayOutputStream serializationOutput, String processName, Object ... args) {
        return ProfilingTimer.create(null, false, serializationOutput, processName, args);
    }

    private static ProfilingTimer create(final Log log, boolean topLevelInfoOnly, ByteArrayOutputStream serializationOutput, final String processName, final Object ... args) {
        if (enabled) {
            if (topLevelInfoOnly) {
                return new ProfilingTimer(null, null, null, new Object[0]){
                    MutableInt level;
                    String logAppendMessage;
                    long startNanos;
                    {
                        super(log3, serializationOutput, processName2, args2);
                        this.level = new MutableInt(0);
                        this.logAppendMessage = "";
                        this.startNanos = System.nanoTime();
                    }

                    @Override
                    public AC start(String taskName, Object ... args2) {
                        if (this.level != null) {
                            this.level.increment();
                        }
                        return new AC(){

                            @Override
                            public void close() {
                                level.decrement();
                            }
                        };
                    }

                    @Override
                    public void end() {
                        this.level.decrement();
                    }

                    @Override
                    public void close() {
                        if (this.startNanos != -1L) {
                            String taskName = String.format(processName, args);
                            try (NDC ac = NDC.push(taskName);){
                                ProfilingTimer.writeToLog(0, System.nanoTime() - this.startNanos, 1L, null, taskName, log, this.logAppendMessage);
                            }
                            this.startNanos = -1L;
                        }
                    }

                    @Override
                    public void appendToLog(String logAppendMessage) {
                        if (this.level.intValue() == 0) {
                            this.logAppendMessage = this.logAppendMessage + logAppendMessage;
                        }
                    }
                };
            }
            return new ProfilingTimer(log, serializationOutput, processName, args);
        }
        return NONE;
    }

    private ProfilingTimer(Log log, ByteArrayOutputStream serializationOutput, String processName, Object ... args) {
        this.log = log;
        this.serializationOutput = serializationOutput;
        this.start(processName, args);
    }

    public void appendToLog(String logAppendMessage) {
        ProfilingTimerNode currentNode = this.current.get();
        if (currentNode != null) {
            currentNode.appendToLog(logAppendMessage);
        }
    }

    public AC start(String taskName, Object ... args) {
        final ProfilingTimerNode parent = this.current.get();
        this.current.set(this.findOrCreateNode(String.format(taskName, args), parent));
        return new AC(){

            @Override
            public void close() {
                ProfilingTimer.this.current.set(parent);
                if (parent != null) {
                    this.stopAll(parent);
                }
            }

            private void stopAll(ProfilingTimerNode current) {
                for (ProfilingTimerNode child : current.children.values()) {
                    this.stopAll(child);
                    child.stop();
                }
            }
        };
    }

    public void end() {
        ProfilingTimerNode currentNode = this.current.get();
        if (currentNode != null) {
            currentNode.stop();
            this.current.set(currentNode.parent);
        }
    }

    public void endAndStart(String taskName, Object ... args) {
        this.end();
        this.start(taskName, args);
    }

    @Override
    public void close() {
        ProfilingTimerNode root = this.current.get();
        while (this.current.get() != null) {
            this.end();
        }
        if (root != null && this.serializationOutput != null) {
            Common.serialize(root, this.serializationOutput);
        }
    }

    public void mergeTree(ProfilingTimerNode otherRoot) {
        ProfilingTimerNode currentNode = this.current.get();
        Preconditions.checkNotNull((Object)currentNode);
        this.mergeOrAddNode(currentNode, otherRoot);
    }

    private void mergeOrAddNode(ProfilingTimerNode parent, ProfilingTimerNode child) {
        ProfilingTimerNode nodeToBeMerged = (ProfilingTimerNode)parent.children.get(child.taskName);
        if (nodeToBeMerged == null) {
            parent.addChild(child);
            return;
        }
        nodeToBeMerged.merge(child);
        for (ProfilingTimerNode grandchild : child.children.values()) {
            this.mergeOrAddNode(nodeToBeMerged, grandchild);
        }
    }

    private ProfilingTimerNode findOrCreateNode(String taskName, ProfilingTimerNode parent) {
        ProfilingTimerNode node = null;
        if (parent != null && (node = (ProfilingTimerNode)parent.children.get(taskName)) != null) {
            node.start = System.nanoTime();
        }
        if (node == null) {
            node = new ProfilingTimerNode(taskName, parent, this.log);
        }
        return node;
    }

    private static void writeToLog(int level, long totalNanos, long count, ProfilingTimerNode parent, String taskName, Log log, String logAppendMessage) {
        if (log == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append('\t');
        }
        String durationText = String.format("%s%s", ProfilingTimer.formatElapsed(totalNanos), count == 1L ? "" : String.format(" across %d invocations, average: %s", count, ProfilingTimer.formatElapsed(totalNanos / count)));
        String text = parent == null ? String.format("total time %s", durationText) : String.format("[%s] took %s", taskName, durationText);
        sb.append(text);
        sb.append(logAppendMessage);
        log.info((Object)sb.toString());
    }

    private static String formatElapsed(long nanos) {
        return String.format("%s (%6.3g nanoseconds)", PeriodFormat.getDefault().print((ReadablePeriod)Period.millis((int)((int)(nanos / 1000L)))), (double)nanos);
    }

    public static class ProfilingTimerNode
    implements Serializable {
        private static final long serialVersionUID = 7464244055073290781L;
        private static final long CLOSED = -1L;
        private final String taskName;
        private String logAppendMessage = "";
        private ProfilingTimerNode parent;
        private final Map<String, ProfilingTimerNode> children = Maps.newLinkedHashMap();
        private final Log log;
        private long start = System.nanoTime();
        private long totalNanos;
        private long count;

        private ProfilingTimerNode(String taskName, ProfilingTimerNode parent, Log log) {
            this.taskName = taskName;
            if (parent != null) {
                parent.addChild(this);
            }
            this.log = log;
        }

        private void addChild(ProfilingTimerNode child) {
            if (child.parent != null) {
                throw new IllegalStateException(String.format("Child [%s] already belongs to parent [%s], can't be added to new parent [%s]", child.taskName, child.parent.taskName, this.taskName));
            }
            child.parent = this;
            this.children.put(child.taskName, child);
        }

        private void stop() {
            if (this.start != -1L) {
                this.totalNanos += System.nanoTime() - this.start;
                ++this.count;
                this.start = -1L;
                if (this.parent == null) {
                    try (NDC ac = NDC.push(this.taskName);){
                        this.log(0, this.log);
                    }
                }
            }
        }

        private void appendToLog(String logAppendMessage) {
            this.logAppendMessage = this.logAppendMessage + logAppendMessage;
        }

        private void log(int level, Log log) {
            ProfilingTimer.writeToLog(level, this.totalNanos, this.count, this.parent, this.taskName, log, this.logAppendMessage);
            for (ProfilingTimerNode child : this.children.values()) {
                child.log(level + 1, log);
            }
        }

        private void merge(ProfilingTimerNode other) {
            Preconditions.checkState((other.start == -1L ? 1 : 0) != 0, (String)"Can't merge non-closed node: %s", (Object[])new Object[]{other.taskName});
            Preconditions.checkState((this.start == -1L ? 1 : 0) != 0, (String)"Can't merge into non-closed nodes: %s", (Object[])new Object[]{this.taskName});
            this.totalNanos += other.totalNanos;
            this.count += other.count;
        }
    }
}

