/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec.util;

import com.medallia.word2vec.util.IO;
import com.medallia.word2vec.util.UnicodeReader;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class Common {
    public static StackTraceElement myCaller(int distance) {
        int index = distance + 1;
        try {
            StackTraceElement[] st = new Throwable().getStackTrace();
            if (st[index].getLineNumber() == 1) {
                return st[index + 1];
            }
            return st[index];
        }
        catch (Throwable t) {
            return new StackTraceElement("[unknown]", "-", "-", 0);
        }
    }

    public static void serialize(Serializable obj, ByteArrayOutputStream bout) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(obj);
            out.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not serialize " + obj, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readToList(File f) throws IOException {
        try (Reader reader = Common.asReaderUTF8Lenient(new FileInputStream(f));){
            List<String> list = Common.readToList(reader);
            return list;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(String.format("Failed to read %s: %s", f.getAbsolutePath(), ioe), ioe);
        }
    }

    public static List<String> readToList(Reader r) throws IOException {
        try (BufferedReader in = new BufferedReader(r);){
            ArrayList<String> l = new ArrayList<String>();
            String line = null;
            while ((line = in.readLine()) != null) {
                l.add(line);
            }
            List<String> list = Collections.unmodifiableList(l);
            return list;
        }
    }

    public static Reader asReaderUTF8Lenient(InputStream in) {
        return new UnicodeReader(in, "utf-8");
    }

    public static String readFileToString(File f) throws IOException {
        StringWriter sw = new StringWriter();
        IO.copyAndCloseBoth(Common.asReaderUTF8Lenient(new FileInputStream(f)), sw);
        return sw.toString();
    }

    public static boolean isEven(int i) {
        return (i & 1) == 0;
    }

    public static boolean isOdd(int i) {
        return !Common.isEven(i);
    }

    public static List<String> readResource(Class<?> clazz, String fn) throws IOException {
        try (Reader reader = Common.asReaderUTF8Lenient(Common.getResourceAsStream(clazz, fn));){
            List<String> list = Common.readToList(reader);
            return list;
        }
    }

    public static InputStream getResourceAsStream(Class<?> clazz, String fn) throws IOException {
        InputStream stream = clazz.getResourceAsStream(fn);
        if (stream == null) {
            throw new IOException("resource \"" + fn + "\" relative to " + clazz + " not found.");
        }
        return Common.unpackStream(stream, fn);
    }

    public static File getResourceAsFile(Class<?> clazz, String fn) throws IOException {
        URL url = clazz.getResource(fn);
        if (url == null || url.getFile() == null) {
            throw new IOException("resource \"" + fn + "\" relative to " + clazz + " not found.");
        }
        return new File(url.getFile());
    }

    public static InputStream unpackStream(InputStream is, String fn) throws IOException {
        if (is == null) {
            throw new FileNotFoundException("InputStream is null for " + fn);
        }
        switch (FilenameUtils.getExtension((String)fn).toLowerCase()) {
            case "gz": {
                return new GZIPInputStream(is);
            }
        }
        return is;
    }

    public static String readResourceToStringChecked(Class<?> clazz, String fn) throws IOException {
        try (InputStream stream = Common.getResourceAsStream(clazz, fn);){
            String string = IOUtils.toString((Reader)Common.asReaderUTF8Lenient(stream));
            return string;
        }
    }
}

