/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec.neuralnetwork;

import com.google.common.collect.Multiset;
import com.medallia.word2vec.Word2VecTrainerBuilder;
import com.medallia.word2vec.huffman.HuffmanCoding;
import com.medallia.word2vec.neuralnetwork.CBOWModelTrainer;
import com.medallia.word2vec.neuralnetwork.NeuralNetworkConfig;
import com.medallia.word2vec.neuralnetwork.NeuralNetworkTrainer;
import com.medallia.word2vec.neuralnetwork.SkipGramModelTrainer;
import java.util.Map;

public enum NeuralNetworkType {
    CBOW{

        @Override
        NeuralNetworkTrainer createTrainer(NeuralNetworkConfig config, Multiset<String> counts, Map<String, HuffmanCoding.HuffmanNode> huffmanNodes, Word2VecTrainerBuilder.TrainingProgressListener listener) {
            return new CBOWModelTrainer(config, counts, huffmanNodes, listener);
        }

        @Override
        public double getDefaultInitialLearningRate() {
            return 0.05;
        }
    }
    ,
    SKIP_GRAM{

        @Override
        NeuralNetworkTrainer createTrainer(NeuralNetworkConfig config, Multiset<String> counts, Map<String, HuffmanCoding.HuffmanNode> huffmanNodes, Word2VecTrainerBuilder.TrainingProgressListener listener) {
            return new SkipGramModelTrainer(config, counts, huffmanNodes, listener);
        }

        @Override
        public double getDefaultInitialLearningRate() {
            return 0.025;
        }
    };


    public abstract double getDefaultInitialLearningRate();

    abstract NeuralNetworkTrainer createTrainer(NeuralNetworkConfig var1, Multiset<String> var2, Map<String, HuffmanCoding.HuffmanNode> var3, Word2VecTrainerBuilder.TrainingProgressListener var4);
}

