/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec.neuralnetwork;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.medallia.word2vec.Word2VecTrainerBuilder;
import com.medallia.word2vec.huffman.HuffmanCoding;
import com.medallia.word2vec.neuralnetwork.NeuralNetworkTrainer;
import com.medallia.word2vec.neuralnetwork.NeuralNetworkType;
import java.util.Map;

public class NeuralNetworkConfig {
    final int numThreads;
    final int iterations;
    final NeuralNetworkType type;
    final int layerSize;
    final int windowSize;
    final int negativeSamples;
    final boolean useHierarchicalSoftmax;
    final double initialLearningRate;
    final double downSampleRate;

    public NeuralNetworkConfig(NeuralNetworkType type, int numThreads, int iterations, int layerSize, int windowSize, int negativeSamples, double downSampleRate, double initialLearningRate, boolean useHierarchicalSoftmax) {
        this.type = type;
        this.iterations = iterations;
        this.numThreads = numThreads;
        this.layerSize = layerSize;
        this.windowSize = windowSize;
        this.negativeSamples = negativeSamples;
        this.useHierarchicalSoftmax = useHierarchicalSoftmax;
        this.initialLearningRate = initialLearningRate;
        this.downSampleRate = downSampleRate;
    }

    public NeuralNetworkTrainer createTrainer(ImmutableMultiset<String> vocab, Map<String, HuffmanCoding.HuffmanNode> huffmanNodes, Word2VecTrainerBuilder.TrainingProgressListener listener) {
        return this.type.createTrainer(this, (Multiset<String>)vocab, huffmanNodes, listener);
    }

    public String toString() {
        return String.format("%s with %s threads, %s iterations[%s layer size, %s window, %s hierarchical softmax, %s negative samples, %s initial learning rate, %s down sample rate]", this.type.name(), this.numThreads, this.iterations, this.layerSize, this.windowSize, this.useHierarchicalSoftmax ? "using" : "not using", this.negativeSamples, this.initialLearningRate, this.downSampleRate);
    }
}

