/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec.neuralnetwork;

import com.google.common.collect.Multiset;
import com.medallia.word2vec.Word2VecTrainerBuilder;
import com.medallia.word2vec.huffman.HuffmanCoding;
import com.medallia.word2vec.neuralnetwork.NeuralNetworkConfig;
import com.medallia.word2vec.neuralnetwork.NeuralNetworkTrainer;
import java.util.List;
import java.util.Map;

class CBOWModelTrainer
extends NeuralNetworkTrainer {
    CBOWModelTrainer(NeuralNetworkConfig config, Multiset<String> counts, Map<String, HuffmanCoding.HuffmanNode> huffmanNodes, Word2VecTrainerBuilder.TrainingProgressListener listener) {
        super(config, counts, huffmanNodes, listener);
    }

    @Override
    NeuralNetworkTrainer.Worker createWorker(int randomSeed, int iter, Iterable<List<String>> batch) {
        return new CBOWWorker(randomSeed, iter, batch);
    }

    private class CBOWWorker
    extends NeuralNetworkTrainer.Worker {
        private CBOWWorker(int randomSeed, int iter, Iterable<List<String>> batch) {
            super(randomSeed, iter, batch);
        }

        @Override
        void trainSentence(List<String> sentence) {
            int sentenceLength = sentence.size();
            for (int sentencePosition = 0; sentencePosition < sentenceLength; ++sentencePosition) {
                int d;
                int idx;
                int a;
                int c;
                String word = sentence.get(sentencePosition);
                HuffmanCoding.HuffmanNode huffmanNode = (HuffmanCoding.HuffmanNode)CBOWModelTrainer.this.huffmanNodes.get(word);
                for (c = 0; c < CBOWModelTrainer.this.layer1_size; ++c) {
                    this.neu1[c] = 0.0;
                }
                for (c = 0; c < CBOWModelTrainer.this.layer1_size; ++c) {
                    this.neu1e[c] = 0.0;
                }
                this.nextRandom = NeuralNetworkTrainer.incrementRandom(this.nextRandom);
                int b = (int)(this.nextRandom % (long)CBOWModelTrainer.this.window + (long)CBOWModelTrainer.this.window) % CBOWModelTrainer.this.window;
                int cw = 0;
                for (a = b; a < CBOWModelTrainer.this.window * 2 + 1 - b; ++a) {
                    int c2;
                    if (a == CBOWModelTrainer.this.window || (c2 = sentencePosition - CBOWModelTrainer.this.window + a) < 0 || c2 >= sentenceLength) continue;
                    idx = ((HuffmanCoding.HuffmanNode)CBOWModelTrainer.this.huffmanNodes.get((Object)sentence.get((int)c2))).idx;
                    for (d = 0; d < CBOWModelTrainer.this.layer1_size; ++d) {
                        int n = d;
                        this.neu1[n] = this.neu1[n] + CBOWModelTrainer.this.syn0[idx][d];
                    }
                    ++cw;
                }
                if (cw == 0) continue;
                int c3 = 0;
                while (c3 < CBOWModelTrainer.this.layer1_size) {
                    int n = c3++;
                    this.neu1[n] = this.neu1[n] / (double)cw;
                }
                if (CBOWModelTrainer.this.config.useHierarchicalSoftmax) {
                    for (int d2 = 0; d2 < huffmanNode.code.length; ++d2) {
                        int c4;
                        double f = 0.0;
                        int l2 = huffmanNode.point[d2];
                        for (int c5 = 0; c5 < CBOWModelTrainer.this.layer1_size; ++c5) {
                            f += this.neu1[c5] * CBOWModelTrainer.this.syn1[l2][c5];
                        }
                        if (f <= -6.0 || f >= 6.0) continue;
                        f = NeuralNetworkTrainer.EXP_TABLE[(int)((f + 6.0) * 83.0)];
                        double g = ((double)(1 - huffmanNode.code[d2]) - f) * CBOWModelTrainer.this.alpha;
                        for (c4 = 0; c4 < CBOWModelTrainer.this.layer1_size; ++c4) {
                            int n = c4;
                            this.neu1e[n] = this.neu1e[n] + g * CBOWModelTrainer.this.syn1[l2][c4];
                        }
                        for (c4 = 0; c4 < CBOWModelTrainer.this.layer1_size; ++c4) {
                            double[] dArray = CBOWModelTrainer.this.syn1[l2];
                            int n = c4;
                            dArray[n] = dArray[n] + g * this.neu1[c4];
                        }
                    }
                }
                this.handleNegativeSampling(huffmanNode);
                for (a = b; a < CBOWModelTrainer.this.window * 2 + 1 - b; ++a) {
                    int c6;
                    if (a == CBOWModelTrainer.this.window || (c6 = sentencePosition - CBOWModelTrainer.this.window + a) < 0 || c6 >= sentenceLength) continue;
                    idx = ((HuffmanCoding.HuffmanNode)CBOWModelTrainer.this.huffmanNodes.get((Object)sentence.get((int)c6))).idx;
                    for (d = 0; d < CBOWModelTrainer.this.layer1_size; ++d) {
                        double[] dArray = CBOWModelTrainer.this.syn0[idx];
                        int n = d;
                        dArray[n] = dArray[n] + this.neu1e[d];
                    }
                }
            }
        }
    }
}

