/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.medallia.word2vec.Searcher;
import com.medallia.word2vec.Word2VecModel;
import com.medallia.word2vec.Word2VecTrainerBuilder;
import com.medallia.word2vec.neuralnetwork.NeuralNetworkType;
import com.medallia.word2vec.thrift.Word2VecModelThrift;
import com.medallia.word2vec.util.AutoLog;
import com.medallia.word2vec.util.Common;
import com.medallia.word2vec.util.Format;
import com.medallia.word2vec.util.ProfilingTimer;
import com.medallia.word2vec.util.Strings;
import com.medallia.word2vec.util.ThriftUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.thrift.TException;

public class Word2VecExamples {
    private static final Log LOG = AutoLog.getLog();

    public static void main(String[] args) throws IOException, TException, Searcher.UnknownWordException, InterruptedException {
        Word2VecExamples.demoWord();
    }

    public static void demoWord() throws IOException, TException, InterruptedException, Searcher.UnknownWordException {
        File f = new File("text8");
        if (!f.exists()) {
            throw new IllegalStateException("Please download and unzip the text8 example from http://mattmahoney.net/dc/text8.zip");
        }
        List<String> read = Common.readToList(f);
        List partitioned = Lists.transform(read, (Function)new Function<String, List<String>>(){

            public List<String> apply(String input) {
                return Arrays.asList(input.split(" "));
            }
        });
        Word2VecModel model = Word2VecModel.trainer().setMinVocabFrequency(5).useNumThreads(20).setWindowSize(8).type(NeuralNetworkType.CBOW).setLayerSize(200).useNegativeSamples(25).setDownSamplingRate(1.0E-4).setNumIterations(5).setListener(new Word2VecTrainerBuilder.TrainingProgressListener(){

            @Override
            public void update(Word2VecTrainerBuilder.TrainingProgressListener.Stage stage, double progress) {
                System.out.println(String.format("%s is %.2f%% complete", Format.formatEnum(stage), progress * 100.0));
            }
        }).train(partitioned);
        try (ProfilingTimer timer = ProfilingTimer.create(LOG, "Writing output to file", new Object[0]);){
            FileUtils.writeStringToFile((File)new File("text8.model"), (String)ThriftUtils.serializeJson(model.toThrift()));
        }
        var5_5 = null;
        try (OutputStream os = Files.newOutputStream(Paths.get("text8.bin", new String[0]), new OpenOption[0]);){
            model.toBinFile(os);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        Word2VecExamples.interact(model.forSearch());
    }

    public static void loadModel() throws IOException, TException, Searcher.UnknownWordException {
        Word2VecModel model;
        try (ProfilingTimer timer = ProfilingTimer.create(LOG, "Loading model", new Object[0]);){
            String json = Common.readFileToString(new File("text8.model"));
            model = Word2VecModel.fromThrift(ThriftUtils.deserializeJson(new Word2VecModelThrift(), json));
        }
        Word2VecExamples.interact(model.forSearch());
    }

    public static void skipGram() throws IOException, TException, InterruptedException, Searcher.UnknownWordException {
        List<String> read = Common.readToList(new File("sents.cleaned.word2vec.txt"));
        List partitioned = Lists.transform(read, (Function)new Function<String, List<String>>(){

            public List<String> apply(String input) {
                return Arrays.asList(input.split(" "));
            }
        });
        Word2VecModel model = Word2VecModel.trainer().setMinVocabFrequency(100).useNumThreads(20).setWindowSize(7).type(NeuralNetworkType.SKIP_GRAM).useHierarchicalSoftmax().setLayerSize(300).useNegativeSamples(0).setDownSamplingRate(0.001).setNumIterations(5).setListener(new Word2VecTrainerBuilder.TrainingProgressListener(){

            @Override
            public void update(Word2VecTrainerBuilder.TrainingProgressListener.Stage stage, double progress) {
                System.out.println(String.format("%s is %.2f%% complete", Format.formatEnum(stage), progress * 100.0));
            }
        }).train(partitioned);
        try (ProfilingTimer timer = ProfilingTimer.create(LOG, "Writing output to file", new Object[0]);){
            FileUtils.writeStringToFile((File)new File("300layer.20threads.5iter.model"), (String)ThriftUtils.serializeJson(model.toThrift()));
        }
        Word2VecExamples.interact(model.forSearch());
    }

    private static void interact(Searcher searcher) throws IOException, Searcher.UnknownWordException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(System.in));){
            while (true) {
                System.out.print("Enter word or sentence (EXIT to break): ");
                String word = br.readLine();
                if (word.equals("EXIT")) {
                    break;
                }
                List<Searcher.Match> matches = searcher.getMatches(word, 20);
                System.out.println(Strings.joinObjects("\n", matches));
            }
        }
    }
}

