/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.List;

public interface Searcher {
    public boolean contains(String var1);

    public ImmutableList<Double> getRawVector(String var1) throws UnknownWordException;

    public List<Match> getMatches(String var1, int var2) throws UnknownWordException;

    public List<Match> getMatches(double[] var1, int var2);

    public SemanticDifference similarity(String var1, String var2) throws UnknownWordException;

    public double cosineDistance(String var1, String var2) throws UnknownWordException;

    public static class UnknownWordException
    extends Exception {
        UnknownWordException(String word) {
            super(String.format("Unknown search word '%s'", word));
        }
    }

    public static interface Match {
        public static final Ordering<Match> ORDERING = Ordering.natural().onResultOf((Function)new Function<Match, Double>(){

            public Double apply(Match match) {
                return match.distance();
            }
        });
        public static final Function<Match, String> TO_WORD = new Function<Match, String>(){

            public String apply(Match result) {
                return result.match();
            }
        };

        public String match();

        public double distance();
    }

    public static interface SemanticDifference {
        public List<Match> getMatches(String var1, int var2) throws UnknownWordException;
    }
}

