/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.util;

import com.mdsol.mauth.exceptions.MAuthSigningException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MAuthSignatureHelper {
    private static final Logger logger = LoggerFactory.getLogger(MAuthSignatureHelper.class);
    private static final Pattern PATTERN_HEX_LOWCASE = Pattern.compile("%[a-f0-9]{2}");

    @Deprecated
    public static String generateUnencryptedSignature(UUID uUID, String string, String string2, String string3, String string4) {
        logger.debug("Generating String to sign for V1");
        return string + "\n" + string2 + "\n" + string3 + "\n" + uUID.toString() + "\n" + string4;
    }

    @Deprecated
    public static byte[] generateUnencryptedSignature(UUID uUID, String string, String string2, byte[] byArray, String string3) throws IOException {
        logger.debug("Generating byte[] to sign for V1");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string4 = string + "\n" + string2 + "\n";
        String string5 = "\n" + uUID.toString() + "\n" + string3;
        byteArrayOutputStream.write(string4.getBytes(StandardCharsets.UTF_8));
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(string5.getBytes(StandardCharsets.UTF_8));
        return byteArrayOutputStream.toByteArray();
    }

    public static String generateStringToSignV2(UUID uUID, String string, String string2, String string3, byte[] byArray, String string4) throws MAuthSigningException {
        logger.debug("Generating String to sign for V2");
        String string5 = MAuthSignatureHelper.getHexEncodedDigestedString(byArray);
        String string6 = MAuthSignatureHelper.generateEncryptedQueryParams(string3);
        return string.toUpperCase() + "\n" + MAuthSignatureHelper.normalizePath(string2) + "\n" + string5 + "\n" + uUID.toString() + "\n" + string4 + "\n" + string6;
    }

    @Deprecated
    public static String encryptSignature(PrivateKey privateKey, String string) throws IOException, CryptoException {
        String string2 = MAuthSignatureHelper.getHexEncodedDigestedString(string);
        return MAuthSignatureHelper.encryptSignaturePKCS1(privateKey, string2);
    }

    @Deprecated
    public static String encryptSignature(PrivateKey privateKey, byte[] byArray) throws IOException, CryptoException {
        String string = MAuthSignatureHelper.getHexEncodedDigestedString(byArray);
        return MAuthSignatureHelper.encryptSignaturePKCS1(privateKey, string);
    }

    @Deprecated
    private static String encryptSignaturePKCS1(PrivateKey privateKey, String string) throws IOException, CryptoException {
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
        pKCS1Encoding.init(true, (CipherParameters)PrivateKeyFactory.createKey((byte[])privateKey.getEncoded()));
        byte[] byArray = pKCS1Encoding.processBlock(string.getBytes(), 0, string.getBytes().length);
        return new String(Base64.encodeBase64((byte[])byArray), StandardCharsets.UTF_8);
    }

    @Deprecated
    public static byte[] decryptSignature(PublicKey publicKey, String string) {
        try {
            byte[] byArray = Base64.decodeBase64((String)string);
            PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
            pKCS1Encoding.init(false, (CipherParameters)PublicKeyFactory.createKey((byte[])publicKey.getEncoded()));
            byte[] byArray2 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
            return byArray2;
        }
        catch (IOException | InvalidCipherTextException throwable) {
            logger.error("Couldn't decrypt the signature using given public key.", throwable);
            throw new MAuthSigningException("Couldn't decrypt the signature using given public key.", throwable);
        }
    }

    public static String getHexEncodedDigestedString(String string) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        return MAuthSignatureHelper.getHexEncodedDigestedString(byArray);
    }

    public static String getHexEncodedDigestedString(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            byte[] byArray2 = messageDigest.digest(byArray);
            return Hex.encodeHexString((byte[])byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.error("Invalid algorithm or security provider.", (Throwable)noSuchAlgorithmException);
            throw new MAuthSigningException("Invalid algorithm or security provider.", noSuchAlgorithmException);
        }
    }

    public static String generateEncryptedQueryParams(String string2) {
        if (string2 == null || string2.isEmpty()) {
            return "";
        }
        return Arrays.stream(string2.split("&")).filter(string -> !string.isEmpty()).map(string -> {
            String[] stringArray = string.split("=");
            String string2 = stringArray[0];
            String string3 = stringArray.length > 1 ? stringArray[1] : "";
            return Pair.of((Object)MAuthSignatureHelper.urlDecodeValue(string2), (Object)MAuthSignatureHelper.urlDecodeValue(string3));
        }).sorted().map(pair -> MAuthSignatureHelper.urlEncodeValue((String)pair.getKey()) + "=" + MAuthSignatureHelper.urlEncodeValue((String)pair.getValue())).collect(Collectors.joining("&"));
    }

    private static String urlEncodeValue(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        try {
            String string2 = URLEncoder.encode(string, StandardCharsets.UTF_8.toString());
            string2 = string2.replace("+", "%20").replace("%7E", "~").replace("*", "%2A");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getCause());
        }
    }

    private static String urlDecodeValue(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        try {
            String string2 = string.replaceAll("%(?![0-9a-fA-F]{2})", "%25").replaceAll("\\+", " ");
            return URLDecoder.decode(string2, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getCause());
        }
    }

    public static String normalizePath(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        Matcher matcher = PATTERN_HEX_LOWCASE.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, matcher.group().toUpperCase());
        }
        matcher.appendTail(stringBuffer);
        String string2 = Paths.get(stringBuffer.toString(), new String[0]).normalize().toString();
        if (!string2.endsWith("/") && (string.endsWith("/") || string.endsWith("/.") || string.endsWith("/.."))) {
            string2 = string2.concat("/");
        }
        return string2;
    }

    public static String encryptSignatureRSA(PrivateKey privateKey, String string) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        Signature signature = Signature.getInstance("SHA512WithRSA");
        signature.initSign(privateKey);
        signature.update(string.getBytes(StandardCharsets.UTF_8));
        return new String(Base64.encodeBase64((byte[])signature.sign()), StandardCharsets.UTF_8);
    }

    public static boolean verifyRSA(String string, String string2, PublicKey publicKey) throws Exception {
        Signature signature = Signature.getInstance("SHA512withRSA");
        signature.initVerify(publicKey);
        signature.update(string.getBytes(StandardCharsets.UTF_8));
        byte[] byArray = Base64.decodeBase64((byte[])string2.getBytes());
        return signature.verify(byArray);
    }
}

