/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.util;

import com.mdsol.mauth.exceptions.MAuthSigningException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MAuthSignatureHelper {
    private static final Logger logger = LoggerFactory.getLogger(MAuthSignatureHelper.class);

    @Deprecated
    public static String generateUnencryptedSignature(UUID uUID, String string, String string2, String string3, String string4) {
        logger.debug("Generating String to sign for V1");
        return string + "\n" + string2 + "\n" + string3 + "\n" + uUID.toString() + "\n" + string4;
    }

    @Deprecated
    public static byte[] generateUnencryptedSignature(UUID uUID, String string, String string2, byte[] byArray, String string3) throws IOException {
        logger.debug("Generating byte[] to sign for V1");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string4 = string + "\n" + string2 + "\n";
        String string5 = "\n" + uUID.toString() + "\n" + string3;
        byteArrayOutputStream.write(string4.getBytes(StandardCharsets.UTF_8));
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(string5.getBytes(StandardCharsets.UTF_8));
        return byteArrayOutputStream.toByteArray();
    }

    public static String generateStringToSignV2(UUID uUID, String string, String string2, String string3, byte[] byArray, String string4) throws MAuthSigningException {
        String string5;
        String string6;
        logger.debug("Generating String to sign for V2");
        try {
            string6 = MAuthSignatureHelper.getHexEncodedDigestedString(byArray);
            string5 = MAuthSignatureHelper.generateEncryptedQueryParams(string3);
        }
        catch (IOException iOException) {
            logger.error("Error generating Unencrypted Signature", (Throwable)iOException);
            throw new MAuthSigningException(iOException);
        }
        return string.toUpperCase() + "\n" + string2 + "\n" + string6 + "\n" + uUID.toString() + "\n" + string4 + "\n" + string5;
    }

    @Deprecated
    public static String encryptSignature(PrivateKey privateKey, String string) throws IOException, CryptoException {
        String string2 = MAuthSignatureHelper.getHexEncodedDigestedString(string);
        return MAuthSignatureHelper.encryptSignaturePKCS1(privateKey, string2);
    }

    @Deprecated
    public static String encryptSignature(PrivateKey privateKey, byte[] byArray) throws IOException, CryptoException {
        String string = MAuthSignatureHelper.getHexEncodedDigestedString(byArray);
        return MAuthSignatureHelper.encryptSignaturePKCS1(privateKey, string);
    }

    @Deprecated
    private static String encryptSignaturePKCS1(PrivateKey privateKey, String string) throws IOException, CryptoException {
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
        pKCS1Encoding.init(true, (CipherParameters)PrivateKeyFactory.createKey((byte[])privateKey.getEncoded()));
        byte[] byArray = pKCS1Encoding.processBlock(string.getBytes(), 0, string.getBytes().length);
        return new String(Base64.encodeBase64((byte[])byArray), StandardCharsets.UTF_8);
    }

    @Deprecated
    public static byte[] decryptSignature(PublicKey publicKey, String string) {
        try {
            byte[] byArray = Base64.decodeBase64((String)string);
            PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
            pKCS1Encoding.init(false, (CipherParameters)PublicKeyFactory.createKey((byte[])publicKey.getEncoded()));
            byte[] byArray2 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
            return byArray2;
        }
        catch (IOException | InvalidCipherTextException throwable) {
            logger.error("Couldn't decrypt the signature using given public key.", throwable);
            throw new MAuthSigningException("Couldn't decrypt the signature using given public key.", throwable);
        }
    }

    public static String getHexEncodedDigestedString(String string) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        return MAuthSignatureHelper.getHexEncodedDigestedString(byArray);
    }

    public static String getHexEncodedDigestedString(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            byte[] byArray2 = messageDigest.digest(byArray);
            return Hex.encodeHexString((byte[])byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.error("Invalid algorithm or security provider.", (Throwable)noSuchAlgorithmException);
            throw new MAuthSigningException("Invalid algorithm or security provider.", noSuchAlgorithmException);
        }
    }

    public static String generateEncryptedQueryParams(String string) throws IOException {
        if (string == null || string.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = string.split("&");
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            String string2;
            String[] stringArray = ((String)object).split("=");
            if (stringArray.length <= 0) continue;
            String string3 = ((String)object).split("=")[0];
            String string4 = string2 = stringArray.length > 1 ? ((String)object).split("=")[1] : "";
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(MAuthSignatureHelper.urlEncodeValue(string3)).append('=').append(MAuthSignatureHelper.urlEncodeValue(string2));
        }
        return stringBuilder.toString();
    }

    private static String urlEncodeValue(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        try {
            String string2 = URLEncoder.encode(string, StandardCharsets.UTF_8.toString());
            string2 = string2.replace("+", "%20");
            string2 = string2.replace("%7E", "~");
            string2 = string2.replace("*", "%2A");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getCause());
        }
    }

    public static String encryptSignatureRSA(PrivateKey privateKey, String string) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        Signature signature = Signature.getInstance("SHA512WithRSA");
        signature.initSign(privateKey);
        signature.update(string.getBytes(StandardCharsets.UTF_8));
        return new String(Base64.encodeBase64((byte[])signature.sign()), StandardCharsets.UTF_8);
    }

    public static boolean verifyRSA(String string, String string2, PublicKey publicKey) throws Exception {
        Signature signature = Signature.getInstance("SHA512withRSA");
        signature.initVerify(publicKey);
        signature.update(string.getBytes(StandardCharsets.UTF_8));
        byte[] byArray = Base64.decodeBase64((byte[])string2.getBytes());
        return signature.verify(byArray);
    }
}

