/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.scaladsl;

import com.mdsol.mauth.MAuthRequest;
import com.mdsol.mauth.MAuthVersion;
import com.mdsol.mauth.exception.MAuthValidationException;
import com.mdsol.mauth.scaladsl.Authenticator;
import com.mdsol.mauth.scaladsl.utils.ClientPublicKeyProvider;
import com.mdsol.mauth.util.EpochTimeProvider;
import com.mdsol.mauth.util.MAuthSignatureHelper;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.UninitializedFieldError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001B\t\u0013\u0001mA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%Q\u0007C\u00039\u0001\u0011\u0005\u0011\bC\u0004?\u0001\t\u0007I\u0011B \t\r!\u0003\u0001\u0015!\u0003A\u0011\u0015A\u0004\u0001\"\u0001J\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u001dA\u0007A1A\u0005B%DaA\u001b\u0001!\u0002\u0013)\u0004\"B6\u0001\t#a\u0007\"\u0002;\u0001\t#)\b\"\u0002=\u0001\t\u0013I\bbBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\b\u0003'\u0001A\u0011BA\u000b\u0011\u001d\tY\u0002\u0001C\u0005\u0003;\u0011ACU3rk\u0016\u001cH/Q;uQ\u0016tG/[2bi>\u0014(BA\n\u0015\u0003!\u00198-\u00197bINd'BA\u000b\u0017\u0003\u0015i\u0017-\u001e;i\u0015\t9\u0002$A\u0003nIN|GNC\u0001\u001a\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\r\"S\"\u0001\n\n\u0005\u0015\u0012\"!D!vi\",g\u000e^5dCR|'/A\tqk\nd\u0017nY&fsB\u0013xN^5eKJ\u0004\"\u0001K\u0016\u000e\u0003%R!A\u000b\n\u0002\u000bU$\u0018\u000e\\:\n\u00051J#aF\"mS\u0016tG\u000fU;cY&\u001c7*Z=Qe>4\u0018\u000eZ3s\u0003E)\u0007o\\2i)&lW\r\u0015:pm&$WM\u001d\t\u0003_Ij\u0011\u0001\r\u0006\u0003cQ\tA!\u001e;jY&\u00111\u0007\r\u0002\u0012\u000bB|7\r\u001b+j[\u0016\u0004&o\u001c<jI\u0016\u0014\u0018A\u0005<3\u001f:d\u00170Q;uQ\u0016tG/[2bi\u0016\u0004\"!\b\u001c\n\u0005]r\"a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\tiZD(\u0010\t\u0003G\u0001AQA\n\u0003A\u0002\u001dBQ!\f\u0003A\u00029BQ\u0001\u000e\u0003A\u0002U\na\u0001\\8hO\u0016\u0014X#\u0001!\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015!B:mMRR'\"A#\u0002\u0007=\u0014x-\u0003\u0002H\u0005\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b\u0005F\u0002;\u0015.CQAJ\u0004A\u0002\u001dBQ!L\u0004A\u00029\nA\"Y;uQ\u0016tG/[2bi\u0016$\"A\u00142\u0015\u0007=+&\fE\u0002Q'Vj\u0011!\u0015\u0006\u0003%z\t!bY8oGV\u0014(/\u001a8u\u0013\t!\u0016K\u0001\u0004GkR,(/\u001a\u0005\u0006-\"\u0001\u001daV\u0001\u0003Kb\u0004\"\u0001\u0015-\n\u0005e\u000b&\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015Y\u0006\u0002q\u0001]\u0003a\u0011X-];fgR4\u0016\r\\5eCRLwN\u001c+j[\u0016|W\u000f\u001e\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?F\u000b\u0001\u0002Z;sCRLwN\\\u0005\u0003Cz\u0013\u0001\u0002R;sCRLwN\u001c\u0005\u0006G\"\u0001\r\u0001Z\u0001\r[\u0006+H\u000f\u001b*fcV,7\u000f\u001e\t\u0003K\u001al\u0011\u0001F\u0005\u0003OR\u0011A\"T!vi\"\u0014V-];fgR\fA#[:We=sG._!vi\",g\u000e^5dCR,W#A\u001b\u0002+%\u001chKM(oYf\fU\u000f\u001e5f]RL7-\u0019;fA\u0005aa/\u00197jI\u0006$X\rV5nKR\u0011Qn\u001c\u000b\u0003k9DQaW\u0006A\u0002qCQ\u0001]\u0006A\u0002E\f1B]3rk\u0016\u001cH\u000fV5nKB\u0011QD]\u0005\u0003gz\u0011A\u0001T8oO\u0006!b/\u00197jI\u0006$X-T1vi\"4VM]:j_:$2!\u000e<x\u0011\u0015\u0019G\u00021\u0001e\u0011\u0015!D\u00021\u00016\u0003M1\u0018\r\\5eCR,7+[4oCR,(/\u001a,2)\r)$p\u001f\u0005\u0006G6\u0001\r\u0001\u001a\u0005\u0006y6\u0001\r!`\u0001\u0010G2LWM\u001c;Qk\nd\u0017nY&fsB\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u0005A1/Z2ve&$\u0018P\u0003\u0002\u0002\u0006\u0005!!.\u0019<b\u0013\r\tIa \u0002\n!V\u0014G.[2LKf\f1C^1mS\u0012\fG/Z*jO:\fG/\u001e:f-J\"R!NA\b\u0003#AQa\u0019\bA\u0002\u0011DQ\u0001 \bA\u0002u\f1DZ1mY\n\f7m\u001b,bY&$\u0017\r^3TS\u001et\u0017\r^;sKZ\u000bD#B\u001b\u0002\u0018\u0005e\u0001\"B2\u0010\u0001\u0004!\u0007\"\u0002?\u0010\u0001\u0004i\u0018\u0001\u00077pO\u0006+H\u000f[3oi&\u001c\u0017\r^5p]J+\u0017/^3tiR!\u0011qDA\u0013!\ri\u0012\u0011E\u0005\u0004\u0003Gq\"\u0001B+oSRDQa\u0019\tA\u0002\u0011\u0004")
public class RequestAuthenticator
implements Authenticator {
    private final ClientPublicKeyProvider publicKeyProvider;
    private final EpochTimeProvider epochTimeProvider;
    private final boolean v2OnlyAuthenticate;
    private final Logger logger;
    private final boolean isV2OnlyAuthenticate;
    private volatile byte bitmap$init$0;

    private Logger logger() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/travis/build/mdsol/mauth-jvm-clients/modules/mauth-authenticator-scala/src/main/scala/com/mdsol/mauth/scaladsl/RequestAuthenticator.scala: 20");
        }
        return this.logger;
    }

    @Override
    public Future<Object> authenticate(MAuthRequest mAuthRequest, ExecutionContext ex, Duration requestValidationTimeout) {
        Promise promise;
        Promise promise2 = Promise$.MODULE$.apply();
        if (!this.validateTime(mAuthRequest.getRequestTime(), requestValidationTimeout)) {
            String message = new StringBuilder(51).append("MAuth request validation failed because of timeout ").append(requestValidationTimeout).toString();
            this.logger().error(message);
            promise = promise2.failure((Throwable)new MAuthValidationException(message));
        } else if (!this.validateMauthVersion(mAuthRequest, this.v2OnlyAuthenticate)) {
            String message = "The service requires mAuth v2 authentication headers.";
            this.logger().error(message);
            promise = promise2.failure((Throwable)new MAuthValidationException(message));
        } else {
            promise = promise2.completeWith(this.publicKeyProvider.getPublicKey(mAuthRequest.getAppUUID()).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RequestAuthenticator.$anonfun$authenticate$1(this, mAuthRequest, x0$1)), ex));
        }
        return promise2.future();
    }

    @Override
    public boolean isV2OnlyAuthenticate() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/travis/build/mdsol/mauth-jvm-clients/modules/mauth-authenticator-scala/src/main/scala/com/mdsol/mauth/scaladsl/RequestAuthenticator.scala: 73");
        }
        return this.isV2OnlyAuthenticate;
    }

    public boolean validateTime(long requestTime, Duration requestValidationTimeout) {
        return this.epochTimeProvider.inSeconds() - requestTime < requestValidationTimeout.toSeconds();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validateMauthVersion(MAuthRequest mAuthRequest, boolean v2OnlyAuthenticate) {
        if (!v2OnlyAuthenticate) return true;
        MAuthVersion mAuthVersion = mAuthRequest.getMauthVersion();
        MAuthVersion mAuthVersion2 = MAuthVersion.MWSV2;
        if (mAuthVersion != null) {
            if (!mAuthVersion.equals(mAuthVersion2)) return false;
            return true;
        }
        if (mAuthVersion2 == null) return true;
        return false;
    }

    private boolean validateSignatureV1(MAuthRequest mAuthRequest, PublicKey clientPublicKey) {
        boolean bl;
        this.logAuthenticationRequest(mAuthRequest);
        byte[] decryptedSignature = MAuthSignatureHelper.decryptSignature((PublicKey)clientPublicKey, (String)mAuthRequest.getRequestSignature());
        try {
            byte[] messageDigest_bytes = MAuthSignatureHelper.generateDigestedMessageV1((MAuthRequest)mAuthRequest).getBytes(StandardCharsets.UTF_8);
            bl = Arrays.equals(messageDigest_bytes, decryptedSignature);
        }
        catch (Exception ex) {
            String message = "MAuth request validation failed for V1.";
            this.logger().error(message, (Throwable)ex);
            throw new MAuthValidationException(message, (Throwable)ex);
        }
        return bl;
    }

    private boolean validateSignatureV2(MAuthRequest mAuthRequest, PublicKey clientPublicKey) {
        boolean bl;
        this.logAuthenticationRequest(mAuthRequest);
        String unencryptedRequestString = MAuthSignatureHelper.generateStringToSignV2((MAuthRequest)mAuthRequest);
        try {
            bl = MAuthSignatureHelper.verifyRSA((String)unencryptedRequestString, (String)mAuthRequest.getRequestSignature(), (PublicKey)clientPublicKey);
        }
        catch (Exception ex) {
            String message = "MAuth request validation failed for V2.";
            this.logger().error(message, (Throwable)ex);
            throw new MAuthValidationException(message, (Throwable)ex);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private boolean fallbackValidateSignatureV1(MAuthRequest mAuthRequest, PublicKey clientPublicKey) {
        void var3_3;
        block1: {
            MAuthRequest mAuthRequestV1;
            boolean isValidated;
            block0: {
                isValidated = false;
                if (mAuthRequest.getMessagePayload() != null) break block0;
                this.logger().warn("V1 authentication fallback is not available because the full request body is not available in memory.");
                break block1;
            }
            if (mAuthRequest.getXmwsSignature() == null || mAuthRequest.getXmwsTime() == null || !(isValidated = this.validateSignatureV1(mAuthRequestV1 = new MAuthRequest(mAuthRequest.getXmwsSignature(), mAuthRequest.getMessagePayload(), mAuthRequest.getHttpMethod(), mAuthRequest.getXmwsTime(), mAuthRequest.getResourcePath(), mAuthRequest.getQueryParameters()), clientPublicKey))) break block1;
            this.logger().warn("Completed successful authentication attempt after fallback to V1");
        }
        return (boolean)var3_3;
    }

    private void logAuthenticationRequest(MAuthRequest mAuthRequest) {
        String msgFormat = "Mauth-client attempting to authenticate request from app with mauth app uuid %s using version %s.";
        this.logger().info(String.format(msgFormat, mAuthRequest.getAppUUID(), mAuthRequest.getMauthVersion().getValue()));
    }

    public static final /* synthetic */ boolean $anonfun$authenticate$1(RequestAuthenticator $this, MAuthRequest mAuthRequest$1, Option x0$1) {
        boolean bl;
        Option option = x0$1;
        if (None$.MODULE$.equals(option)) {
            $this.logger().error("Public Key couldn't be retrieved");
            bl = false;
        } else if (option instanceof Some) {
            boolean bl2;
            Some some = (Some)option;
            PublicKey clientPublicKey = (PublicKey)some.value();
            MAuthVersion mAuthVersion = mAuthRequest$1.getMauthVersion();
            if (MAuthVersion.MWS.equals(mAuthVersion)) {
                bl2 = $this.validateSignatureV1(mAuthRequest$1, clientPublicKey);
            } else if (MAuthVersion.MWSV2.equals(mAuthVersion)) {
                boolean v2IsValidated = $this.validateSignatureV2(mAuthRequest$1, clientPublicKey);
                bl2 = $this.v2OnlyAuthenticate ? v2IsValidated : (v2IsValidated ? v2IsValidated : $this.fallbackValidateSignatureV1(mAuthRequest$1, clientPublicKey));
            } else {
                throw new MatchError((Object)mAuthVersion);
            }
            bl = bl2;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public RequestAuthenticator(ClientPublicKeyProvider publicKeyProvider, EpochTimeProvider epochTimeProvider, boolean v2OnlyAuthenticate) {
        this.publicKeyProvider = publicKeyProvider;
        this.epochTimeProvider = epochTimeProvider;
        this.v2OnlyAuthenticate = v2OnlyAuthenticate;
        this.logger = LoggerFactory.getLogger(RequestAuthenticator.class);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.isV2OnlyAuthenticate = v2OnlyAuthenticate;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public RequestAuthenticator(ClientPublicKeyProvider publicKeyProvider, EpochTimeProvider epochTimeProvider) {
        this(publicKeyProvider, epochTimeProvider, false);
    }
}

