/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.filecache;

import com.mchange.v1.io.InputStreamUtils;
import com.mchange.v1.io.OutputStreamUtils;
import com.mchange.v2.io.DirectoryDescentUtils;
import com.mchange.v2.io.FileIterator;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v3.filecache.FileCacheKey;
import com.mchange.v3.filecache.FileNotCachedException;
import com.mchange.v3.filecache.URLFetcher;
import com.mchange.v3.filecache.URLFetchers;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class FileCache {
    static final MLogger logger = MLog.getLogger(FileCache.class);
    final File cacheDir;
    final int buffer_size;
    final boolean read_only;
    final List<URLFetcher> fetchers;
    static final FileFilter NOT_DIR_FF = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return !f.isDirectory();
        }
    };

    private InputStream fetchURL(URL u) throws IOException {
        LinkedList<IOException> exceptions = null;
        for (URLFetcher fetcher : this.fetchers) {
            try {
                return fetcher.openStream(u, logger);
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "URLFetcher " + fetcher + " failed on Exception. Will try next fetcher, if any.", e);
                }
                if (exceptions == null) {
                    exceptions = new LinkedList<IOException>();
                }
                exceptions.add(e);
            }
        }
        if (logger.isLoggable(MLevel.WARNING)) {
            logger.log(MLevel.WARNING, "All URLFetchers failed on URL " + u);
            int len = exceptions.size();
            for (int i = 0; i < len; ++i) {
                logger.log(MLevel.WARNING, "URLFetcher Exception #" + (i + 1), (Throwable)exceptions.get(i));
            }
        }
        throw new IOException("Failed to fetch URL '" + u + "'.");
    }

    public FileCache(File cacheDir, int buffer_size, boolean read_only) throws IOException {
        this(cacheDir, buffer_size, read_only, Collections.singletonList(URLFetchers.DEFAULT));
    }

    public FileCache(File cacheDir, int buffer_size, boolean read_only, URLFetcher ... fetchers) throws IOException {
        this(cacheDir, buffer_size, read_only, Arrays.asList(fetchers));
    }

    public FileCache(File cacheDir, int buffer_size, boolean read_only, List<URLFetcher> fetchers) throws IOException {
        this.cacheDir = cacheDir;
        this.buffer_size = buffer_size;
        this.read_only = read_only;
        this.fetchers = Collections.unmodifiableList(fetchers);
        if (cacheDir.exists()) {
            if (!cacheDir.isDirectory()) {
                this.loggedIOException(MLevel.SEVERE, cacheDir + "exists and is not a directory. Can't use as cacheDir.");
            } else if (!cacheDir.canRead()) {
                this.loggedIOException(MLevel.SEVERE, cacheDir + "must be readable.");
            } else if (!cacheDir.canWrite() && !read_only) {
                this.loggedIOException(MLevel.SEVERE, cacheDir + "not writable, and not read only.");
            }
        } else if (!cacheDir.mkdir()) {
            this.loggedIOException(MLevel.SEVERE, cacheDir + "does not exist and could not be created.");
        }
    }

    public void ensureCached(FileCacheKey key, boolean force_reacquire) throws IOException {
        block13: {
            File f;
            block11: {
                block12: {
                    BufferedOutputStream os;
                    BufferedInputStream is;
                    block10: {
                        f = this.file(key);
                        if (this.read_only) break block11;
                        if (!force_reacquire && f.exists()) break block12;
                        is = null;
                        os = null;
                        try {
                            File dir;
                            if (logger.isLoggable(MLevel.FINE)) {
                                logger.log(MLevel.FINE, "Caching file for " + key + " to " + f.getAbsolutePath() + "...");
                            }
                            if (!(dir = f.getParentFile()).exists()) {
                                dir.mkdirs();
                            }
                            is = new BufferedInputStream(this.fetchURL(key.getURL()), this.buffer_size);
                            os = new BufferedOutputStream(new FileOutputStream(f), this.buffer_size);
                            int b = ((InputStream)is).read();
                            while (b >= 0) {
                                ((OutputStream)os).write(b);
                                b = ((InputStream)is).read();
                            }
                            if (!logger.isLoggable(MLevel.INFO)) break block10;
                            logger.log(MLevel.INFO, "Cached file for " + key + ".");
                        }
                        catch (IOException e) {
                            try {
                                logger.log(MLevel.WARNING, "An exception occurred while caching file for " + key + ". Deleting questionable cached file.", e);
                                f.delete();
                                throw e;
                            }
                            catch (Throwable throwable) {
                                InputStreamUtils.attemptClose(is);
                                OutputStreamUtils.attemptClose(os);
                                throw throwable;
                            }
                        }
                    }
                    InputStreamUtils.attemptClose(is);
                    OutputStreamUtils.attemptClose(os);
                    break block13;
                }
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "File for " + key + " already exists and force_reacquire is not set.");
                }
                break block13;
            }
            if (force_reacquire) {
                String message = "force_reacquire canot be set on a read_only FileCache.";
                IllegalArgumentException e = new IllegalArgumentException(message);
                logger.log(MLevel.WARNING, message, e);
                throw e;
            }
            if (!f.exists()) {
                String message = "Cache is read only, and file for key '" + key + "' does not exist.";
                FileNotCachedException e = new FileNotCachedException(message);
                logger.log(MLevel.FINE, message, e);
                throw e;
            }
        }
    }

    public InputStream fetch(FileCacheKey key, boolean force_reacquire) throws IOException {
        this.ensureCached(key, force_reacquire);
        return new FileInputStream(this.file(key));
    }

    public boolean isCached(FileCacheKey key) throws IOException {
        return this.file(key).exists();
    }

    public int countCached() throws IOException {
        int count = 0;
        FileIterator fi = DirectoryDescentUtils.depthFirstEagerDescent(this.cacheDir, NOT_DIR_FF, false);
        while (fi.hasNext()) {
            fi.next();
            ++count;
        }
        return count;
    }

    public int countCached(FileFilter filter) throws IOException {
        int count = 0;
        FileIterator fi = DirectoryDescentUtils.depthFirstEagerDescent(this.cacheDir, new NotDirAndFileFilter(filter), false);
        while (fi.hasNext()) {
            fi.next();
            ++count;
        }
        return count;
    }

    public File fileForKey(FileCacheKey key) {
        return this.file(key);
    }

    private File file(FileCacheKey key) {
        return new File(this.cacheDir, key.getCacheFilePath());
    }

    private void loggedIOException(MLevel lvl, String msg) throws IOException {
        IOException e = new IOException(msg);
        logger.log(lvl, msg, e);
        throw e;
    }

    static class NotDirAndFileFilter
    implements FileFilter {
        FileFilter ff;

        NotDirAndFileFilter(FileFilter ff) {
            this.ff = ff;
        }

        @Override
        public boolean accept(File f) {
            return !f.isDirectory() && this.ff.accept(f);
        }
    }
}

