/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.cachedstore;

import com.mchange.v1.cachedstore.CachedStore;
import com.mchange.v1.cachedstore.ManualCleanupSoftKeyCachedStore;
import com.mchange.v1.cachedstore.NoCacheCachedStore;
import com.mchange.v1.cachedstore.NoCacheWritableCachedStore;
import com.mchange.v1.cachedstore.NoCleanupCachedStore;
import com.mchange.v1.cachedstore.SimpleWritableCachedStore;
import com.mchange.v1.cachedstore.SoftReferenceCachedStore;
import com.mchange.v1.cachedstore.TweakableCachedStore;
import com.mchange.v1.cachedstore.WritableCachedStore;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class CachedStoreFactory {
    public static TweakableCachedStore createNoCleanupCachedStore(CachedStore.Manager manager) {
        return new NoCleanupCachedStore(manager);
    }

    public static TweakableCachedStore createSoftValueCachedStore(CachedStore.Manager manager) {
        return new SoftReferenceCachedStore(manager);
    }

    public static TweakableCachedStore createSynchronousCleanupSoftKeyCachedStore(CachedStore.Manager manager) {
        final ManualCleanupSoftKeyCachedStore inner = new ManualCleanupSoftKeyCachedStore(manager);
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
                inner.vacuum();
                return m.invoke((Object)inner, args);
            }
        };
        return (TweakableCachedStore)Proxy.newProxyInstance(CachedStoreFactory.class.getClassLoader(), new Class[]{TweakableCachedStore.class}, handler);
    }

    public static TweakableCachedStore createNoCacheCachedStore(CachedStore.Manager mgr) {
        return new NoCacheCachedStore(mgr);
    }

    public static WritableCachedStore createDefaultWritableCachedStore(WritableCachedStore.Manager manager) {
        TweakableCachedStore readOnlyCache = CachedStoreFactory.createSynchronousCleanupSoftKeyCachedStore(manager);
        return new SimpleWritableCachedStore(readOnlyCache, manager);
    }

    public static WritableCachedStore cacheWritesOnlyWritableCachedStore(WritableCachedStore.Manager mgr) {
        TweakableCachedStore readOnlyCache = CachedStoreFactory.createNoCacheCachedStore(mgr);
        return new SimpleWritableCachedStore(readOnlyCache, mgr);
    }

    public static WritableCachedStore createNoCacheWritableCachedStore(WritableCachedStore.Manager mgr) {
        return new NoCacheWritableCachedStore(mgr);
    }
}

