/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph;

import com.mastfrog.abstractions.list.IndexedResolvable;
import com.mastfrog.bits.Bits;
import com.mastfrog.bits.MutableBits;
import com.mastfrog.bits.collections.BitSetSet;
import com.mastfrog.graph.BitSetGraph;
import com.mastfrog.graph.IntGraph;
import com.mastfrog.graph.IntGraphVisitor;
import com.mastfrog.graph.IntPath;
import com.mastfrog.graph.ObjectGraphVisitor;
import com.mastfrog.graph.ObjectPath;
import com.mastfrog.graph.StringGraph;
import com.mastfrog.graph.algorithm.Algorithm;
import com.mastfrog.graph.algorithm.RankingAlgorithm;
import com.mastfrog.graph.algorithm.Score;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;

final class BitSetStringGraph
implements StringGraph {
    private final IntGraph tree;
    private final String[] items;
    private transient IndexedImpl indexedImpl;

    BitSetStringGraph(IntGraph tree, String[] sortedArray) {
        this.tree = tree;
        this.items = sortedArray;
    }

    @Override
    public void toIntGraph(BiConsumer<IndexedResolvable<? extends String>, IntGraph> consumer) {
        consumer.accept((IndexedResolvable<? extends String>)IndexedResolvable.fromArray((Comparable[])this.items), this.tree);
    }

    static boolean sanityCheckArray(String[] sortedArray) {
        assert (new HashSet<String>(Arrays.asList(sortedArray)).size() == sortedArray.length) : "Array contains duplicates: " + Arrays.toString(sortedArray);
        List<String> a = Arrays.asList(sortedArray);
        ArrayList<String> b = new ArrayList<String>(a);
        Collections.sort(b);
        assert (a.equals(b)) : "Array is not sorted: " + a;
        return true;
    }

    IndexedImpl indexedImpl() {
        if (this.indexedImpl == null) {
            this.indexedImpl = new IndexedImpl();
        }
        return this.indexedImpl;
    }

    Set<String> toSet(Bits bits) {
        return new BitSetSet((IndexedResolvable)this.indexedImpl(), bits);
    }

    Set<String> newSet() {
        return this.toSet((Bits)MutableBits.create((int)this.items.length));
    }

    @Override
    public List<ObjectPath<String>> pathsBetween(String a, String b) {
        int aix = this.toNodeId(a);
        int bix = this.toNodeId(b);
        List<IntPath> raw = this.tree.pathsBetween(aix, bix);
        ArrayList<ObjectPath<String>> result = new ArrayList<ObjectPath<String>>(raw.size());
        for (IntPath ip : raw) {
            ObjectPath<String> op = new ObjectPath<String>(ip, this.indexedImpl());
            result.add(op);
        }
        return result;
    }

    @Override
    public void save(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.items);
        this.tree.save(out);
    }

    static BitSetStringGraph load(ObjectInput in) throws IOException, ClassNotFoundException {
        int v = in.readInt();
        if (v != 1) {
            throw new IOException("Unsupoorted version " + v);
        }
        String[] sortedArray = (String[])in.readObject();
        BitSetGraph tree = BitSetGraph.load(in);
        return new BitSetStringGraph(tree, sortedArray);
    }

    @Override
    public void walk(final ObjectGraphVisitor<? super String> v) {
        this.tree.walk(new IntGraphVisitor(){

            @Override
            public void enterNode(int node, int depth) {
                v.enterNode(BitSetStringGraph.this.toNode(node), depth);
            }

            @Override
            public void exitNode(int node, int depth) {
                v.exitNode(BitSetStringGraph.this.toNode(node), depth);
            }
        });
    }

    @Override
    public void walk(String start, final ObjectGraphVisitor<? super String> v) {
        int ix = this.toNodeId(start);
        if (ix < 0) {
            return;
        }
        this.tree.walk(ix, new IntGraphVisitor(){

            @Override
            public void enterNode(int node, int depth) {
                v.enterNode(BitSetStringGraph.this.toNode(node), depth);
            }

            @Override
            public void exitNode(int node, int depth) {
                v.exitNode(BitSetStringGraph.this.toNode(node), depth);
            }
        });
    }

    @Override
    public void walkUpwards(String start, final ObjectGraphVisitor<? super String> v) {
        int ix = this.toNodeId(start);
        if (ix < 0) {
            return;
        }
        this.tree.walkUpwards(ix, new IntGraphVisitor(){

            @Override
            public void enterNode(int node, int depth) {
                v.enterNode(BitSetStringGraph.this.toNode(node), depth);
            }

            @Override
            public void exitNode(int node, int depth) {
                v.exitNode(BitSetStringGraph.this.toNode(node), depth);
            }
        });
    }

    @Override
    public int distance(String a, String b) {
        int ixA = this.toNodeId(a);
        int ixB = this.toNodeId(b);
        if (ixA < 0 || ixB < 0) {
            return Integer.MAX_VALUE;
        }
        return this.tree.distance(ixA, ixB);
    }

    public Set<String> disjointItems() {
        Bits all = this.tree.disjointNodes();
        HashSet<String> result = new HashSet<String>();
        all.forEachSetBitAscending(i -> result.add(this.toNode(i)));
        return result;
    }

    public Set<String> disjunctionOfClosureOfMostCentralNodes() {
        List<Score<String>> centrality = this.eigenvectorCentrality();
        double sum = 0.0;
        for (int i = 0; i < centrality.size() / 2; ++i) {
            sum += centrality.get(i).score();
        }
        double avg = sum / (double)(centrality.size() / 2);
        HashSet<String> result = new HashSet<String>(centrality.size());
        centrality.stream().filter(s -> s.score() >= avg).forEach(s -> result.add((String)s.node()));
        return result;
    }

    @Override
    public Set<String> disjunctionOfClosureOfHighestRankedNodes() {
        List<Score<String>> centrality = this.pageRank();
        double sum = 0.0;
        for (int i = 0; i < centrality.size() / 2; ++i) {
            sum += centrality.get(i).score();
        }
        double avg = sum / (double)(centrality.size() / 2);
        HashSet<String> result = new HashSet<String>(centrality.size());
        centrality.stream().filter(s -> s.score() >= avg).forEach(s -> result.add((String)s.node()));
        return result;
    }

    @Override
    public List<Score<String>> eigenvectorCentrality() {
        return this.apply(Algorithm.eigenvectorCentrality());
    }

    @Override
    public List<Score<String>> pageRank() {
        return this.apply(Algorithm.pageRank());
    }

    @Override
    public List<String> byClosureSize() {
        int[] cs = this.tree.byClosureSize();
        ArrayList<String> result = new ArrayList<String>(cs.length);
        for (int i = 0; i < cs.length; ++i) {
            result.add(this.toNode(cs[i]));
        }
        return result;
    }

    @Override
    public List<String> byReverseClosureSize() {
        int[] cs = this.tree.byReverseClosureSize();
        ArrayList<String> result = new ArrayList<String>(cs.length);
        for (int i = 0; i < cs.length; ++i) {
            result.add(this.toNode(cs[i]));
        }
        return result;
    }

    @Override
    public Set<String> parents(String node) {
        int ix = this.toNodeId(node);
        if (ix == -1) {
            return Collections.emptySet();
        }
        return this.setOf(this.tree.parents(ix));
    }

    @Override
    public Set<String> children(String node) {
        int ix = this.toNodeId(node);
        if (ix == -1) {
            return Collections.emptySet();
        }
        return this.setOf(this.tree.children(ix));
    }

    @Override
    public Set<String> edgeStrings() {
        TreeSet<String> result = new TreeSet<String>();
        this.tree.edges((a, b) -> result.add(this.toNode(a) + ":" + this.toNode(b)));
        return result;
    }

    @Override
    public int toNodeId(String name) {
        int ix = Arrays.binarySearch(this.items, name);
        if (ix < 0) {
            return -1;
        }
        return ix;
    }

    @Override
    public String toNode(int index) {
        return this.items[index];
    }

    private Set<String> setOf(Bits set) {
        return set.isEmpty() ? Collections.emptySet() : this.toSet(set);
    }

    @Override
    public int inboundReferenceCount(String node) {
        int ix = this.toNodeId(node);
        return ix < 0 ? 0 : this.tree.inboundReferenceCount(ix);
    }

    @Override
    public int outboundReferenceCount(String node) {
        int ix = this.toNodeId(node);
        return ix < 0 ? 0 : this.tree.outboundReferenceCount(ix);
    }

    @Override
    public Set<String> topLevelOrOrphanNodes() {
        return this.setOf(this.tree.topLevelOrOrphanNodes());
    }

    @Override
    public Set<String> bottomLevelNodes() {
        return this.setOf(this.tree.bottomLevelNodes());
    }

    @Override
    public boolean isUnreferenced(String node) {
        int ix = this.toNodeId(node);
        return ix < 0 ? true : this.tree.isUnreferenced(ix);
    }

    @Override
    public int closureSize(String node) {
        int ix = this.toNodeId(node);
        return ix < 0 ? 0 : this.tree.closureSize(ix);
    }

    @Override
    public int reverseClosureSize(String node) {
        int ix = this.toNodeId(node);
        return ix < 0 ? 0 : this.tree.reverseClosureSize(ix);
    }

    @Override
    public Set<String> reverseClosureOf(String node) {
        int ix = this.toNodeId(node);
        return ix < 0 ? Collections.emptySet() : this.setOf(this.tree.reverseClosureOf(ix));
    }

    @Override
    public Set<String> closureOf(String node) {
        int ix = this.toNodeId(node);
        return ix < 0 ? Collections.emptySet() : this.setOf(this.tree.closureOf(ix));
    }

    public boolean hasInboundEdge(String from, String to) {
        int f = this.toNodeId(from);
        int t = this.toNodeId(to);
        return f < 0 || t < 0 ? false : this.tree.hasInboundEdge(f, t);
    }

    public boolean hasOutboundEdge(String from, String to) {
        int f = this.toNodeId(from);
        int t = this.toNodeId(to);
        return f < 0 || t < 0 ? false : this.tree.hasOutboundEdge(f, t);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        this.walk((ObjectGraphVisitor<? super String>)((ObjectGraphVisitor<String>)(node, depth) -> {
            char[] c = new char[depth * 2];
            Arrays.fill(c, ' ');
            sb.append(c).append((String)node).append('\n');
        }));
        sb.append("Tops:");
        this.topsString(sb);
        sb.append('\n').append("Bottoms: ");
        this.bottomsString(sb);
        return sb.toString();
    }

    private void topsString(StringBuilder into) {
        this.tree.topLevelOrOrphanNodes().forEachSetBitAscending(i -> into.append(' ').append(this.toNode(i)));
    }

    private void bottomsString(StringBuilder into) {
        this.tree.bottomLevelNodes().forEachSetBitAscending(i -> into.append(' ').append(this.toNode(i)));
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.tree);
        hash = 79 * hash + Arrays.deepHashCode(this.items);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitSetStringGraph other = (BitSetStringGraph)obj;
        if (!Objects.equals(this.tree, other.tree)) {
            return false;
        }
        return Arrays.deepEquals(this.items, other.items);
    }

    @Override
    public List<Score<String>> apply(RankingAlgorithm<?> alg) {
        return alg.apply(this.tree, this::toNode);
    }

    public StringGraph omitting(Set<String> items) {
        int total = 0;
        int[] indices = new int[items.size()];
        for (String item : items) {
            int ix = this.indexedImpl.indexOf(item);
            if (ix < 0) continue;
            indices[total++] = ix;
        }
        if (total < items.size()) {
            indices = Arrays.copyOf(indices, total);
        }
        ArrayList newItems = new ArrayList(this.indexedImpl.toList());
        newItems.removeAll(items);
        return new BitSetStringGraph(this.tree.omitting(indices), newItems.toArray(new String[newItems.size()]));
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    class IndexedImpl
    implements IndexedResolvable<String> {
        List<String> list;

        IndexedImpl() {
            this.list = Arrays.asList(BitSetStringGraph.this.items);
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public String forIndex(int index) {
            return BitSetStringGraph.this.toNode(index);
        }

        public int size() {
            return BitSetStringGraph.this.items.length;
        }
    }
}

