/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph;

import com.mastfrog.abstractions.list.IndexedResolvable;
import com.mastfrog.function.IntBiConsumer;
import com.mastfrog.graph.BitSetUtils;
import com.mastfrog.graph.IntGraph;
import com.mastfrog.graph.IntGraphBuilder;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class PairSet
implements Iterable<int[]> {
    private final int size;
    private final BitSet set;

    PairSet(int size) {
        this.set = new BitSet(size * size);
        this.size = size;
    }

    private PairSet(int size, BitSet set) {
        this.size = size;
        this.set = set;
    }

    public static PairSet fromIntArray(int[][] ints) {
        PairSet set = new PairSet(ints.length);
        for (int[] pair : ints) {
            set.add(pair[0], pair[1]);
        }
        return set;
    }

    public boolean isEmpty() {
        return this.set.cardinality() == 0;
    }

    public int pairCount() {
        return this.set.cardinality();
    }

    public PairSet copy() {
        return new PairSet(this.size, (BitSet)this.set.clone());
    }

    public PairSet inverse() {
        return new PairSet(this.size, BitSetUtils.invert(this.set, this.size));
    }

    public int size() {
        return this.size;
    }

    public PairSet add(int x, int y) {
        this.set.set(this.positionOf(x, y));
        return this;
    }

    public PairSet remove(int x, int y) {
        this.set.clear(this.positionOf(x, y));
        return this;
    }

    public PairSet retainAll(PairSet other) {
        BitSet nue = (BitSet)this.set.clone();
        nue.and(other.set);
        return new PairSet(this.size, nue);
    }

    public PairSet removingAll(PairSet other) {
        BitSet nue = (BitSet)this.set.clone();
        nue.andNot(other.set);
        return new PairSet(this.size, nue);
    }

    public boolean intersects(PairSet other) {
        return this.set.intersects(other.set);
    }

    public boolean contains(int x, int y) {
        return this.set.get(this.positionOf(x, y));
    }

    int positionOf(int x, int y) {
        int result = x + y * this.size;
        return result;
    }

    int[] coordinatesOf(int position) {
        int x = position % this.size;
        int y = position / this.size;
        return new int[]{x, y};
    }

    @Override
    public Iterator<int[]> iterator() {
        return new Iter();
    }

    public IntGraph toGraph() {
        IntGraphBuilder bldr = IntGraph.builder(this.size);
        int bit = this.set.nextSetBit(0);
        while (bit >= 0) {
            int x = bit % this.size;
            int y = bit / this.size;
            bldr.addEdge(x, y);
            bit = this.set.nextSetBit(bit + 1);
        }
        return bldr.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int bit = this.set.nextSetBit(0);
        while (bit >= 0) {
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            int x = bit % this.size;
            int y = bit / this.size;
            sb.append(x).append(',').append(y);
            bit = this.set.nextSetBit(bit + 1);
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + this.size;
        hash = 71 * hash + Objects.hashCode(this.set);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PairSet other = (PairSet)obj;
        if (this.size != other.size) {
            return false;
        }
        return Objects.equals(this.set, other.set);
    }

    public <T> ObjectPairSet<T> toObjectPairSet(IndexedResolvable<T> indexed) {
        return new ObjectPairSet<T>(this, indexed);
    }

    public int forEach(IntBiConsumer bi) {
        int count = 0;
        int position = this.set.nextSetBit(0);
        while (position >= 0) {
            int x = position % this.size;
            int y = position / this.size;
            bi.accept(x, y);
            ++count;
            position = this.set.nextSetBit(position + 1);
        }
        return count;
    }

    public static final class ObjectPairSet<T>
    implements Iterable<Map.Entry<T, T>> {
        private final PairSet pairs;
        private final IndexedResolvable<T> indexed;

        ObjectPairSet(PairSet pairs, IndexedResolvable<T> indexed) {
            this.pairs = pairs;
            this.indexed = indexed;
        }

        public int size() {
            return this.pairs.pairCount();
        }

        public boolean contains(T a, T b) {
            int aix = this.indexed.indexOf(a);
            int bix = this.indexed.indexOf(b);
            return this.pairs.contains(aix, bix);
        }

        @Override
        public Iterator<Map.Entry<T, T>> iterator() {
            return new OIter();
        }

        static final class En<T>
        implements Map.Entry<T, T> {
            private final T a;
            private final T b;

            En(T a, T b) {
                this.a = a;
                this.b = b;
            }

            @Override
            public T getKey() {
                return this.a;
            }

            @Override
            public T getValue() {
                return this.b;
            }

            @Override
            public T setValue(T value) {
                throw new UnsupportedOperationException("Read only.");
            }

            @Override
            public int hashCode() {
                int hash = 5;
                hash = 97 * hash + Objects.hashCode(this.a);
                hash = 97 * hash + Objects.hashCode(this.b);
                return hash;
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry other = (Map.Entry)obj;
                if (!Objects.equals(this.a, other.getKey())) {
                    return false;
                }
                return Objects.equals(this.b, other.getValue());
            }
        }

        class OIter
        implements Iterator<Map.Entry<T, T>> {
            Iterator<int[]> iter;

            OIter() {
                this.iter = ObjectPairSet.this.pairs.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Map.Entry<T, T> next() {
                int[] pair = this.iter.next();
                Object a = ObjectPairSet.this.indexed.forIndex(pair[0]);
                Object b = ObjectPairSet.this.indexed.forIndex(pair[1]);
                return new En<Object>(a, b);
            }
        }
    }

    final class Iter
    implements Iterator<int[]> {
        int bit;
        boolean done;

        Iter() {
            this.findNext();
        }

        void findNext() {
            this.bit = PairSet.this.set.nextSetBit(this.bit);
            this.done = this.bit < 0;
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return !this.done && this.bit >= 0;
        }

        @Override
        public int[] next() {
            if (this.bit < 0) {
                throw new NoSuchElementException();
            }
            this.findNext();
            int[] result = PairSet.this.coordinatesOf(this.bit);
            ++this.bit;
            return result;
        }
    }
}

