/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph;

import com.mastfrog.abstractions.list.IndexedResolvable;
import com.mastfrog.bits.collections.BitSetSet;
import com.mastfrog.graph.IntPath;
import com.mastfrog.util.preconditions.Checks;
import java.lang.reflect.Array;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public final class ObjectPath<T>
implements Iterable<T>,
Comparable<ObjectPath> {
    private final IntPath ip;
    private final IndexedResolvable<? extends T> indexed;

    ObjectPath(IntPath ip, IndexedResolvable<? extends T> indexed) {
        this.ip = ip;
        this.indexed = (IndexedResolvable)Checks.notNull((String)"indexed", indexed);
    }

    public ObjectPath prepending(T obj) {
        int ix = this.indexed.indexOf(obj);
        if (ix < 0) {
            return null;
        }
        return new ObjectPath<T>(this.ip.prepending(ix), this.indexed);
    }

    public ObjectPath appending(T obj) {
        int ix = this.indexed.indexOf(obj);
        if (ix < 0) {
            return null;
        }
        return new ObjectPath<T>(this.ip.appending(ix), this.indexed);
    }

    public Set<? extends T> contents() {
        BitSet set = new BitSet(this.ip.size());
        this.ip.forEachInt(set::set);
        return new BitSetSet(this.indexed, set);
    }

    public int size() {
        return this.ip.size();
    }

    public T first() {
        if (this.ip.isEmpty()) {
            throw new NoSuchElementException("empty path");
        }
        return (T)this.indexed.forIndex(this.ip.first());
    }

    public T last() {
        if (this.ip.isEmpty()) {
            throw new NoSuchElementException("empty path");
        }
        return (T)this.indexed.forIndex(this.ip.last());
    }

    public T get(int i) {
        int value = this.ip.get(i);
        return (T)this.indexed.forIndex(value);
    }

    public boolean containsPath(ObjectPath<T> other) {
        return this.ip.contains(other.ip);
    }

    public boolean contains(T obj) {
        int ix = this.indexOf(obj);
        return ix >= 0;
    }

    public int indexOf(T obj) {
        int ix = this.indexed.indexOf(obj);
        return ix < 0 ? -1 : this.ip.indexOf(ix);
    }

    public int lastIndexOf(T obj) {
        int ix = this.indexed.indexOf(obj);
        return ix < 0 ? -1 : this.ip.lastIndexOf(ix);
    }

    public ObjectPath<T> childPath() {
        if (this.isEmpty()) {
            return this;
        }
        return new ObjectPath<T>(this.ip.childPath(), this.indexed);
    }

    public ObjectPath<T> parentPath() {
        if (this.isEmpty()) {
            return this;
        }
        return new ObjectPath<T>(this.ip.childPath(), this.indexed);
    }

    public boolean isEmpty() {
        return this.ip.isEmpty();
    }

    public boolean isNotAPath() {
        return this.ip.isNotAPath();
    }

    public ObjectPath<T> reversed() {
        return new ObjectPath<T>(this.ip.reversed(), this.indexed);
    }

    public T start() {
        if (this.ip.isEmpty()) {
            return null;
        }
        return (T)this.indexed.forIndex(this.ip.get(0));
    }

    public T end() {
        if (this.ip.isEmpty()) {
            return null;
        }
        return (T)this.indexed.forIndex(this.ip.get(this.size() - 1));
    }

    public int hashCode() {
        return this.ip.hashCode();
    }

    private String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Class) {
            Class c = (Class)o;
            if (c.isArray()) {
                return c.getComponentType().getSimpleName() + "[]";
            }
            return c.getSimpleName();
        }
        if (o.getClass().isArray()) {
            StringBuilder sb = new StringBuilder(60);
            int max = Array.getLength(o);
            for (int i = 0; i < max; ++i) {
                Object item = Array.get(o, i);
                sb.append(Objects.toString(item));
            }
            return sb.append(']').toString();
        }
        return o.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        for (int i = 0; i < this.size(); ++i) {
            T obj = this.get(i);
            if (sb.length() != 0) {
                sb.append('/');
            }
            sb.append(this.toString(obj));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ObjectPath) {
            ObjectPath other = (ObjectPath)o;
            return other.ip.equals(this.ip);
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter();
    }

    @Override
    public int compareTo(ObjectPath o) {
        return this.ip.compareTo(o.ip);
    }

    final class Iter
    implements Iterator<T> {
        int ix = -1;

        Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.ix + 1 < ObjectPath.this.size();
        }

        @Override
        public T next() {
            return ObjectPath.this.get(++this.ix);
        }

        public String toString() {
            return "Iter(" + ObjectPath.this + " @ " + this.ix + ")";
        }
    }
}

