/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph;

import com.mastfrog.abstractions.list.IndexedResolvable;
import com.mastfrog.graph.ObjectPath;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.function.IntConsumer;

public final class IntPath
implements Comparable<IntPath>,
Iterable<Integer> {
    private static int DEFAULT_SIZE = 12;
    private int[] items;
    private int size;
    private BitSet contents;
    private int cachedHashCode = 0;

    private IntPath(int size, int[] items) {
        this.size = size;
        this.items = Arrays.copyOf(items, size + DEFAULT_SIZE);
    }

    IntPath(int initialItems) {
        this.items = new int[initialItems];
    }

    IntPath() {
        this(DEFAULT_SIZE);
    }

    IntPath copy() {
        return new IntPath(this.size, this.items);
    }

    public IntPath prepending(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Paths may not contain negative elements: " + value);
        }
        int[] nue = new int[this.size + 1];
        System.arraycopy(this.items, 0, nue, 1, this.items.length);
        nue[0] = value;
        IntPath result = new IntPath(nue.length, nue);
        if (this.contents != null) {
            BitSet newContents = (BitSet)this.contents.clone();
            newContents.set(value);
            result.contents = newContents;
        }
        return result;
    }

    public IntPath appending(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Paths may not contain negative elements: " + value);
        }
        int[] nue = new int[this.size + 1];
        System.arraycopy(this.items, 0, nue, 0, this.items.length);
        this.items[this.size] = value;
        IntPath result = new IntPath(nue.length, nue);
        if (this.contents != null) {
            BitSet newContents = (BitSet)this.contents.clone();
            newContents.set(value);
            result.contents = newContents;
        }
        return result;
    }

    public void forEachInt(IntConsumer c) {
        for (int i = 0; i < this.size; ++i) {
            c.accept(this.items[i]);
        }
    }

    public void forEachIntReversed(IntConsumer c) {
        for (int i = this.size - 1; i >= 0; --i) {
            c.accept(this.items[i]);
        }
    }

    public int first() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("Empty");
        }
        return this.items[0];
    }

    public int last() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("empty");
        }
        return this.items[this.size - 1];
    }

    private void growIfNeeded() {
        if (this.size == this.items.length - 1) {
            this.items = Arrays.copyOf(this.items, this.items.length + DEFAULT_SIZE);
        }
    }

    IntPath addAll(int ... values) {
        if (values.length == 0) {
            return this;
        }
        if (this.size + values.length < this.items.length) {
            this.items = Arrays.copyOf(this.items, this.items.length + values.length);
        }
        System.arraycopy(values, 0, this.items, this.size, values.length);
        this.size += values.length;
        this.contents = null;
        this.cachedHashCode = 0;
        return this;
    }

    IntPath add(int item) {
        this.growIfNeeded();
        this.items[this.size++] = item;
        this.contents = null;
        this.cachedHashCode = 0;
        return this;
    }

    IntPath append(IntPath other) {
        if (other.isEmpty()) {
            return this;
        }
        int targetSize = this.size() + other.size();
        if (this.items.length < targetSize) {
            this.items = Arrays.copyOf(this.items, targetSize);
        }
        System.arraycopy(other.items, 0, this.items, this.size, other.size());
        this.size = targetSize;
        this.contents = null;
        this.cachedHashCode = 0;
        return this;
    }

    IntPath trim() {
        this.items = Arrays.copyOf(this.items, this.size);
        return this;
    }

    public IntPath childPath() {
        if (this.size == 0) {
            return this;
        }
        int[] nue = new int[this.size - 1];
        System.arraycopy(this.items, 1, nue, 0, nue.length);
        return new IntPath(nue.length, nue);
    }

    public IntPath parentPath() {
        if (this.size == 0) {
            return this;
        }
        int[] nue = new int[this.size - 1];
        System.arraycopy(this.items, 0, nue, 0, nue.length);
        return new IntPath(nue.length, nue);
    }

    IntPath replace(int index, IntPath other) {
        this.size = index;
        this.append(other);
        this.contents = null;
        this.cachedHashCode = 0;
        return this;
    }

    public IntPath reversed() {
        int[] nue = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            nue[i] = this.items[this.size - (i + 1)];
        }
        IntPath result = new IntPath(this.size, nue);
        result.contents = this.contents;
        return result;
    }

    public int start() {
        return this.size == 0 ? -1 : this.items[0];
    }

    public int end() {
        return this.size == 0 ? -1 : this.items[this.size - 1];
    }

    public boolean contains(IntPath path) {
        int i;
        if (path == this) {
            return true;
        }
        if (path.size() > this.size) {
            return false;
        }
        if (path.size() == this.size) {
            return path.equals(this);
        }
        BitSet ct = this.contents();
        for (i = 0; i < path.size; ++i) {
            if (ct.get(path.get(i))) continue;
            return false;
        }
        for (i = 0; i < this.size - path.size(); ++i) {
            if (!IntPath.arraysEquals(this.items, i, i + path.size(), path.items, 0, path.size())) continue;
            return true;
        }
        return false;
    }

    private BitSet contents() {
        if (this.contents != null) {
            return this.contents;
        }
        BitSet result = new BitSet(this.size);
        for (int i = 0; i < this.items.length; ++i) {
            result.set(this.items[i]);
        }
        return result;
    }

    static boolean arraysEquals(int[] a, int aFromIndex, int aToIndex, int[] b, int bFromIndex, int bToIndex) {
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        while (aFromIndex < aToIndex && bFromIndex < bToIndex) {
            if (a[aFromIndex] != b[bFromIndex]) {
                return false;
            }
            ++aFromIndex;
            ++bFromIndex;
        }
        return true;
    }

    public int indexOf(int val) {
        if (!this.contains(val)) {
            return -1;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.get(i) != val) continue;
            return i;
        }
        throw new AssertionError((Object)"contents bitset out of sync");
    }

    public int lastIndexOf(int val) {
        if (!this.contains(val)) {
            return -1;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.get(i) != val) continue;
            return i;
        }
        throw new AssertionError((Object)"contents bitset out of sync");
    }

    public boolean contains(int val) {
        if (val < 0) {
            throw new IllegalArgumentException("Cannot contain negative values: " + val);
        }
        return this.contents().get(val);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isNotAPath() {
        return this.size() < 2;
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(index + " of " + this.size);
        }
        return this.items[index];
    }

    public int[] items() {
        return this.size == this.items.length ? this.items : Arrays.copyOf(this.items, this.size);
    }

    @Deprecated
    public void iterate(IntConsumer cons) {
        for (int i = 0; i < this.size; ++i) {
            cons.accept(this.get(i));
        }
        cons.accept(-1);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof IntPath)) {
            return false;
        }
        IntPath ip = (IntPath)o;
        if (this.size != ip.size || this.hashCode() != ip.hashCode()) {
            return false;
        }
        return IntPath.arraysEquals(this.items, 0, this.size, ip.items, 0, this.size);
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + this.items[i];
        }
        this.cachedHashCode = result;
        return this.cachedHashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(24);
        for (int i = 0; i < this.size(); ++i) {
            int value = this.get(i);
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public <T> ObjectPath<T> toObjectPath(IndexedResolvable<T> indexed) {
        return new ObjectPath<T>(this, indexed);
    }

    @Override
    public int compareTo(IntPath o) {
        int b;
        int a = this.size();
        return a > (b = o.size()) ? 1 : (a < b ? -1 : 0);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IIt();
    }

    class IIt
    implements Iterator<Integer> {
        int pos = -1;

        IIt() {
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < IntPath.this.size();
        }

        @Override
        public Integer next() {
            return IntPath.this.get(++this.pos);
        }
    }
}

