/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph.algorithm;

import com.mastfrog.graph.IntGraph;
import com.mastfrog.graph.algorithm.Algorithm;
import com.mastfrog.graph.algorithm.RankingAlgorithm;
import java.util.function.IntToDoubleFunction;

public final class PageRank
extends RankingAlgorithm<PageRank> {
    public static Algorithm.IntParameter<PageRank> MAXIMUM_ITERATIONS = Algorithm.createIntegerParameter(PageRank.class, "maximumIterations");
    public static Algorithm.DoubleParameter<PageRank> MINIMUM_DIFFERENCE = Algorithm.createDoubleParameter(PageRank.class, "minimumDifference");
    public static Algorithm.DoubleParameter<PageRank> DAMPING_FACTOR = Algorithm.createDoubleParameter(PageRank.class, "dampingFactor");
    public static Algorithm.BooleanParameter<PageRank> NORMALIZE = Algorithm.createBooleanParameter(PageRank.class, "normalize");
    private double minDifference;
    private double dampingFactor;
    private int maximumIterations;
    private boolean normalize;

    PageRank(double minDifference, double dampingFactor, int maximumIterations, boolean normalize) {
        this.minDifference = minDifference;
        this.dampingFactor = dampingFactor;
        this.maximumIterations = maximumIterations;
        this.normalize = normalize;
    }

    PageRank() {
        this(4.0E-16, 1.0E-11, 1000, true);
    }

    double sum(int size, IntToDoubleFunction func) {
        double result = 0.0;
        for (int i = 0; i < size; ++i) {
            result += func.applyAsDouble(i);
        }
        return result;
    }

    @Override
    public double[] apply(IntGraph graph) {
        double difference;
        int cnt = 0;
        int graphSize = graph.size();
        double n = graphSize;
        double[] result = new double[graphSize];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = 1.0 / n;
        }
        do {
            difference = 0.0;
            double danglingFactor = 0.0;
            if (this.normalize) {
                danglingFactor = this.dampingFactor / n * this.sum(graphSize, i -> {
                    if (graph.children(i).isEmpty()) {
                        return result[i];
                    }
                    return 0.0;
                });
            }
            for (int i3 = 0; i3 < graphSize; ++i3) {
                double inputSum = graph.parents(i3).sum(j -> {
                    double outDegree = graph.children(j).cardinality();
                    if (outDegree != 0.0) {
                        return result[j] / outDegree;
                    }
                    return 0.0;
                });
                double val = (1.0 - this.dampingFactor) / n + this.dampingFactor * inputSum + danglingFactor;
                difference += Math.abs(val - result[i3]);
                if (!(result[i3] < val)) continue;
                result[i3] = val;
            }
        } while (difference > this.minDifference && ++cnt < this.maximumIterations);
        return result;
    }

    @Override
    public PageRank setParameter(Algorithm.BooleanParameter<PageRank> param, boolean value) {
        if (NORMALIZE == param) {
            this.normalize = value;
            return this;
        }
        return super.setParameter(param, value);
    }

    @Override
    public PageRank setParameter(Algorithm.DoubleParameter<PageRank> param, double value) {
        if (MINIMUM_DIFFERENCE == param) {
            this.minDifference = value;
            return this;
        }
        if (DAMPING_FACTOR == param) {
            this.dampingFactor = value;
            return this;
        }
        return super.setParameter(param, value);
    }

    @Override
    public PageRank setParameter(Algorithm.IntParameter<PageRank> param, int value) {
        if (MAXIMUM_ITERATIONS == param) {
            this.maximumIterations = value;
            return this;
        }
        return super.setParameter(param, value);
    }
}

