/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph.algorithm;

import com.mastfrog.bits.Bits;
import com.mastfrog.graph.IntGraph;
import com.mastfrog.graph.algorithm.Algorithm;
import com.mastfrog.graph.algorithm.RankingAlgorithm;
import java.util.Arrays;

public final class EigenvectorCentrality
extends RankingAlgorithm<EigenvectorCentrality> {
    public static Algorithm.IntParameter<EigenvectorCentrality> MAXIMUM_ITERATIONS = EigenvectorCentrality.createIntegerParameter(EigenvectorCentrality.class, "maximumIterations");
    public static Algorithm.DoubleParameter<EigenvectorCentrality> MINIMUM_DIFFERENCE = EigenvectorCentrality.createDoubleParameter(EigenvectorCentrality.class, "minimumDifference");
    public static Algorithm.BooleanParameter<EigenvectorCentrality> USE_IN_EDGES = EigenvectorCentrality.createBooleanParameter(EigenvectorCentrality.class, "inEdges");
    public static Algorithm.BooleanParameter<EigenvectorCentrality> IGNORE_SELF_EDGES = EigenvectorCentrality.createBooleanParameter(EigenvectorCentrality.class, "ignoreSelfEdges");
    public static Algorithm.BooleanParameter<EigenvectorCentrality> NORMALIZE = EigenvectorCentrality.createBooleanParameter(EigenvectorCentrality.class, "normalize");
    private int maxIterations;
    private double minDiff;
    private boolean inEdges;
    private boolean ignoreSelfEdges;
    private boolean normalize;

    EigenvectorCentrality() {
        this(400, 1.0E-6, false, true, true);
    }

    EigenvectorCentrality(int maxIterations, double minDiff, boolean inEdges, boolean ignoreSelfEdges, boolean normalize) {
        this.maxIterations = maxIterations;
        this.minDiff = minDiff;
        this.inEdges = inEdges;
        this.ignoreSelfEdges = ignoreSelfEdges;
        this.normalize = normalize;
    }

    @Override
    public double[] apply(IntGraph graph) {
        int sz = graph.size();
        double[] unnormalized = new double[sz];
        double[] centrality = new double[sz];
        Arrays.fill(centrality, 1.0 / (double)sz);
        double diff = 0.0;
        int iter = 0;
        do {
            for (int i = 0; i < sz; ++i) {
                double s;
                int j;
                double sum;
                Bits dests = this.inEdges ? graph.parents(i) : graph.neighbors(i);
                unnormalized[i] = sum = dests.sum(centrality, this.ignoreSelfEdges ? i : Integer.MIN_VALUE);
                if (this.normalize) {
                    double l2sum = 0.0;
                    for (j = 0; j < sz; ++j) {
                        l2sum += unnormalized[j] * unnormalized[j];
                    }
                    s = l2sum == 0.0 ? 1.0 : 1.0 / Math.sqrt(l2sum);
                } else {
                    double l1sum = 0.0;
                    for (j = 0; j < sz; ++j) {
                        l1sum += unnormalized[j];
                    }
                    s = l1sum == 0.0 ? 1.0 : 1.0 / l1sum;
                }
                diff = 0.0;
                for (int j2 = 0; j2 < sz; ++j2) {
                    double val = unnormalized[j2] * s;
                    diff += Math.abs(centrality[j2] - val);
                    centrality[j2] = val;
                }
            }
        } while (iter++ < this.maxIterations && diff > this.minDiff);
        return centrality;
    }

    @Override
    public EigenvectorCentrality setParameter(Algorithm.DoubleParameter<EigenvectorCentrality> param, double value) {
        if (MINIMUM_DIFFERENCE == param) {
            this.minDiff = value;
            return this;
        }
        return super.setParameter(param, value);
    }

    @Override
    public EigenvectorCentrality setParameter(Algorithm.IntParameter<EigenvectorCentrality> param, int value) {
        if (MAXIMUM_ITERATIONS == param) {
            this.maxIterations = value;
            return this;
        }
        return super.setParameter(param, value);
    }

    @Override
    public EigenvectorCentrality setParameter(Algorithm.BooleanParameter<EigenvectorCentrality> param, boolean value) {
        if (USE_IN_EDGES == param) {
            this.inEdges = value;
            return this;
        }
        if (IGNORE_SELF_EDGES == param) {
            this.ignoreSelfEdges = value;
            return this;
        }
        if (NORMALIZE == param) {
            this.normalize = value;
            return this;
        }
        return super.setParameter(param, value);
    }
}

