/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph;

import com.mastfrog.bits.Bits;
import com.mastfrog.bits.MutableBits;
import com.mastfrog.function.IntBiConsumer;
import com.mastfrog.graph.BitSetStringGraph;
import com.mastfrog.graph.IntGraph;
import com.mastfrog.graph.IntGraphVisitor;
import com.mastfrog.graph.IntPath;
import com.mastfrog.graph.PairSet;
import com.mastfrog.graph.StringGraph;
import com.mastfrog.graph.algorithm.Algorithm;
import com.mastfrog.graph.algorithm.EigenvectorCentrality;
import com.mastfrog.graph.algorithm.PageRank;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;

final class BitSetGraph
implements IntGraph {
    private final Bits[] outboundEdges;
    private final Bits[] inboundEdges;
    private final Bits topLevel;
    private final Bits bottomLevel;

    BitSetGraph(BitSet[] outboundEdges, BitSet[] inboundEdges) {
        this(BitSetGraph.toBits(outboundEdges), BitSetGraph.toBits(inboundEdges));
    }

    BitSetGraph(BitSet[] edges) {
        this(BitSetGraph.toBits(edges));
    }

    BitSetGraph(Bits[] outboundEdges, Bits[] inboundEdges) {
        assert (this.sanityCheck(outboundEdges, inboundEdges));
        this.outboundEdges = outboundEdges;
        this.inboundEdges = inboundEdges;
        Bits outboundKeys = BitSetGraph.keySet(outboundEdges);
        Bits inboundKeys = BitSetGraph.keySet(inboundEdges);
        MutableBits top = MutableBits.create((int)outboundEdges.length);
        MutableBits bottom = MutableBits.create((int)inboundEdges.length);
        top.or(outboundKeys);
        bottom.or(inboundKeys);
        top.andNot(inboundKeys);
        bottom.andNot(outboundKeys);
        this.topLevel = top.readOnlyView();
        this.bottomLevel = bottom.readOnlyView();
        this.checkConsistency();
    }

    private static Bits[] toBits(BitSet[] sets) {
        Bits[] bits = new Bits[sets.length];
        for (int i = 0; i < sets.length; ++i) {
            bits[i] = Bits.fromBitSet((BitSet)sets[i]);
        }
        return bits;
    }

    BitSetGraph(Bits[] references) {
        this(references, (Bits[])BitSetGraph.inverseOf(references));
    }

    @Override
    public boolean containsEdge(int a, int b) {
        if (a > this.outboundEdges.length || b > this.outboundEdges.length || a < 0 || b < 0) {
            return false;
        }
        boolean result = this.outboundEdges[a].get(b);
        assert (!result || this.inboundEdges[b].get(a)) : "State inconsistent for " + a + "," + b;
        return result;
    }

    void checkConsistency() {
        boolean asserts = false;
        if (!$assertionsDisabled) {
            asserts = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        assert (this.outboundEdges.length == this.inboundEdges.length) : "Array sizes differ";
        if (asserts) {
            for (int i = 0; i < this.outboundEdges.length; ++i) {
                Bits set = this.outboundEdges[i];
                int bit = set.nextSetBit(0);
                while (bit >= 0) {
                    Bits opposite = this.inboundEdges[bit];
                    assert (opposite.get(i));
                    bit = set.nextSetBit(bit + 1);
                }
            }
        }
    }

    @Override
    public void save(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.outboundEdges.length);
        for (Bits outboundEdge : this.outboundEdges) {
            if (outboundEdge.cardinality() > 0) {
                out.writeObject(outboundEdge.toByteArray());
                continue;
            }
            out.writeObject(null);
        }
        out.flush();
    }

    public static BitSetGraph load(ObjectInput in) throws IOException, ClassNotFoundException {
        int ver = in.readInt();
        if (ver != 1) {
            throw new IOException("Unsupoorted version " + ver);
        }
        int count = in.readInt();
        MutableBits[] sets = new MutableBits[count];
        for (int i = 0; i < sets.length; ++i) {
            byte[] vals = (byte[])in.readObject();
            sets[i] = vals == null ? Bits.EMPTY : MutableBits.valueOf((byte[])vals);
        }
        return new BitSetGraph((Bits[])sets);
    }

    private static MutableBits[] inverseOf(Bits[] outbound) {
        int size = outbound.length;
        MutableBits empty = null;
        MutableBits[] inbound = new MutableBits[size];
        for (int i = 0; i < size; ++i) {
            if (outbound[i] == null) {
                if (empty == null) {
                    empty = MutableBits.create((int)0);
                }
                outbound[i] = empty;
            }
            for (int j = 0; j < size; ++j) {
                Bits b = outbound[j];
                if (b == null || !b.get(i)) continue;
                if (inbound[i] == null) {
                    inbound[i] = MutableBits.create((int)size);
                }
                inbound[i].set(j);
            }
            if (inbound[i] != null) continue;
            if (empty == null) {
                empty = MutableBits.create((int)0);
            }
            inbound[i] = empty;
        }
        return inbound;
    }

    private boolean sanityCheck(Bits[] outbound, Bits[] inbound) {
        boolean asserts = false;
        if (!$assertionsDisabled) {
            asserts = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!asserts) {
            return true;
        }
        assert (outbound.length == inbound.length) : "MutableBits array lengths do not match: " + outbound.length + " and " + inbound.length;
        for (int i = 0; i < outbound.length; ++i) {
            int ix = i;
            outbound[i].forEachSetBitAscending(bit -> {
                Bits reverse = inbound[bit];
                assert (reverse.get(ix)) : "ruleReferences[" + ix + "] says it references " + bit + " but referencedBy[" + bit + "] does not have " + ix + " set - ruleReferences: " + this.bitSetArrayToString(outbound) + " referencedBy: " + this.bitSetArrayToString(inbound);
            });
        }
        return true;
    }

    private String bitSetArrayToString(Bits[] arr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            Bits b = arr[i];
            if (b.isEmpty()) {
                sb.append(i).append(": empty\n");
                continue;
            }
            sb.append(i).append(": ").append(b).append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("BitSetTree{size=").append(this.outboundEdges.length).append(", totalCardinality=").append(this.totalCardinality()).append("}\n");
        this.walk((id, d) -> {
            char[] c = new char[d * 2];
            Arrays.fill(c, ' ');
            sb.append(c).append(id).append('\n');
        });
        return sb.toString();
    }

    @Override
    public void walk(IntGraphVisitor v) {
        BitSet traversed = new BitSet(this.size());
        this.walk(v, this.topLevel, traversed, 0);
        int bit = traversed.nextClearBit(0);
        while (bit >= 0 && bit < this.size()) {
            this.walk(v, this.outboundEdges[bit], traversed, 0);
            bit = traversed.nextClearBit(bit + 1);
        }
    }

    @Override
    public void walk(int startingWith, IntGraphVisitor v) {
        MutableBits set = MutableBits.create((int)this.size());
        set.set(startingWith);
        this.walk(v, (Bits)set, new BitSet(this.size()), 0);
    }

    private void walk(IntGraphVisitor v, Bits traverse, BitSet seen, int depth) {
        traverse.forEachSetBitAscending(bit -> {
            if (!seen.get(bit)) {
                seen.set(bit);
                v.enterNode(bit, depth);
                this.walk(v, this.outboundEdges[bit], seen, depth + 1);
                v.exitNode(bit, depth);
            }
        });
    }

    @Override
    public void walkUpwards(IntGraphVisitor v) {
        int size = this.size();
        BitSet traversed = new BitSet(size);
        this.walkUpwards(v, this.bottomLevel, traversed, 0);
        int bit = traversed.previousClearBit(size - 1);
        while (bit >= 0 && bit < size && bit < size) {
            this.walk(v, this.inboundEdges[bit], traversed, 0);
            bit = traversed.previousClearBit(bit - 1);
        }
    }

    @Override
    public void walkUpwards(int startingWith, IntGraphVisitor v) {
        MutableBits set = MutableBits.create((int)this.size());
        set.set(startingWith);
        this.walkUpwards(v, (Bits)set, new BitSet(this.size()), 0);
    }

    private void walkUpwards(IntGraphVisitor v, Bits traverse, BitSet seen, int depth) {
        traverse.forEachSetBitAscending(bit -> {
            if (!seen.get(bit)) {
                seen.set(bit);
                v.enterNode(bit, depth);
                this.walkUpwards(v, this.inboundEdges[bit], seen, depth + 1);
            }
        });
    }

    @Override
    public void edges(IntBiConsumer bi) {
        for (int i = 0; i < this.size(); ++i) {
            int index = i;
            this.outboundEdges[i].forEachSetBitAscending(bit -> bi.accept(index, bit));
        }
    }

    @Override
    public PairSet allEdges() {
        PairSet set = new PairSet(this.size());
        this.edges(set::add);
        return set;
    }

    @Override
    public int size() {
        return this.outboundEdges.length;
    }

    @Override
    public Bits closureDisjunction(int a, int b) {
        if (a == b) {
            return MutableBits.create((int)0);
        }
        MutableBits ca = this._closureOf(a);
        MutableBits cb = this._closureOf(b);
        ca.xor((Bits)cb);
        return ca;
    }

    @Override
    public Bits closureUnion(int a, int b) {
        if (a == b) {
            return MutableBits.create((int)0);
        }
        MutableBits ca = this._closureOf(a);
        MutableBits cb = this._closureOf(b);
        ca.or((Bits)cb);
        return ca;
    }

    @Override
    public int distance(int a, int b) {
        Optional<IntPath> path = this.shortestPathBetween(a, b);
        if (path.isPresent()) {
            return path.get().size();
        }
        path = this.shortestPathBetween(b, a);
        if (path.isPresent()) {
            return path.get().size();
        }
        return -1;
    }

    @Override
    public Bits closureDisjunction(int ... nodes) {
        MutableBits result = MutableBits.create((int)this.size());
        for (int i = 0; i < nodes.length; ++i) {
            MutableBits clos = this._closureOf(nodes[i]);
            if (i == 0) {
                result.or((Bits)clos);
                continue;
            }
            result.xor((Bits)clos);
        }
        return result;
    }

    @Override
    public Bits closureDisjunction(Bits nodes) {
        MutableBits result = MutableBits.create((int)this.size());
        int bit = nodes.nextSetBit(0);
        int count = 0;
        while (bit >= 0 && bit < this.size()) {
            MutableBits clos = this._closureOf(bit);
            if (count == 0) {
                result.or((Bits)clos);
            } else {
                result.xor((Bits)clos);
            }
            bit = nodes.nextSetBit(bit + 1);
            ++count;
        }
        return result;
    }

    @Override
    public double[] eigenvectorCentrality(int maxIterations, double minDiff, boolean inEdges, boolean ignoreSelfEdges, boolean l2norm) {
        return ((EigenvectorCentrality)((EigenvectorCentrality)((EigenvectorCentrality)((EigenvectorCentrality)((EigenvectorCentrality)Algorithm.eigenvectorCentrality().setParameter((Algorithm.IntParameter)EigenvectorCentrality.MAXIMUM_ITERATIONS, maxIterations)).setParameter((Algorithm.DoubleParameter)EigenvectorCentrality.MINIMUM_DIFFERENCE, minDiff)).setParameter((Algorithm.BooleanParameter)EigenvectorCentrality.USE_IN_EDGES, inEdges)).setParameter((Algorithm.BooleanParameter)EigenvectorCentrality.IGNORE_SELF_EDGES, ignoreSelfEdges)).setParameter((Algorithm.BooleanParameter)EigenvectorCentrality.NORMALIZE, l2norm)).apply(this);
    }

    public double sum(IntToDoubleFunction func) {
        double result = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            result += func.applyAsDouble(i);
        }
        return result;
    }

    @Override
    public double[] pageRank(double minDifference, double dampingFactor, int maximumIterations, boolean normalize) {
        return ((PageRank)((PageRank)((PageRank)((PageRank)Algorithm.pageRank().setParameter((Algorithm.DoubleParameter)PageRank.MINIMUM_DIFFERENCE, minDifference)).setParameter((Algorithm.DoubleParameter)PageRank.DAMPING_FACTOR, dampingFactor)).setParameter((Algorithm.IntParameter)PageRank.MAXIMUM_ITERATIONS, maximumIterations)).setParameter((Algorithm.BooleanParameter)PageRank.NORMALIZE, normalize)).apply(this);
    }

    @Override
    public boolean isReachableFrom(int a, int b) {
        return this.closureOf(a).get(b);
    }

    @Override
    public boolean isReverseReachableFrom(int a, int b) {
        return this.closureOf(b).get(a);
    }

    @Override
    public Bits neighbors(int startingNode) {
        MutableBits result = this.inboundEdges[startingNode].mutableCopy();
        result.or(this.outboundEdges[startingNode]);
        return result;
    }

    @Override
    public void depthFirstSearch(int startingNode, boolean up, IntConsumer cons) {
        this.depthFirstSearch(startingNode, up, cons, MutableBits.create((int)this.size()));
    }

    @Override
    public void breadthFirstSearch(int startingNode, boolean up, IntConsumer cons) {
        this.breadthFirstSearch(startingNode, up, cons, MutableBits.create((int)this.size()));
    }

    private void breadthFirstSearch(int startingNode, boolean up, IntConsumer cons, MutableBits traversed) {
        Bits dests = up ? this.inboundEdges[startingNode] : this.outboundEdges[startingNode];
        boolean any = false;
        int bit = dests.nextSetBit(0);
        while (bit >= 0) {
            if (!traversed.get(bit)) {
                cons.accept(bit);
                any = true;
            }
            bit = dests.nextSetBit(bit + 1);
        }
        if (!any) {
            return;
        }
        bit = dests.nextSetBit(0);
        while (bit >= 0) {
            if (!traversed.get(bit)) {
                this.breadthFirstSearch(bit, up, cons, traversed);
                traversed.set(bit);
            }
            bit = dests.nextSetBit(bit + 1);
        }
    }

    private void depthFirstSearch(int startingNode, boolean up, IntConsumer cons, MutableBits traversed) {
        Bits dests = up ? this.inboundEdges[startingNode] : this.outboundEdges[startingNode];
        boolean any = false;
        int bit = dests.nextSetBit(0);
        while (bit >= 0) {
            if (!traversed.get(bit)) {
                this.depthFirstSearch(bit, up, cons, traversed);
                any = true;
            }
            bit = dests.nextSetBit(bit + 1);
        }
        if (!any) {
            return;
        }
        bit = dests.nextSetBit(0);
        while (bit >= 0) {
            if (!traversed.get(bit)) {
                traversed.set(bit);
                cons.accept(bit);
            }
            bit = dests.nextSetBit(bit + 1);
        }
    }

    @Override
    public boolean abortableDepthFirstSearch(int startingNode, boolean up, IntPredicate cons) {
        return this.abortableDepthFirstSearch(startingNode, up, cons, MutableBits.create((int)this.size()));
    }

    @Override
    public boolean abortableBreadthFirstSearch(int startingNode, boolean up, IntPredicate cons) {
        return this.abortableBreadthFirstSearch(startingNode, up, cons, MutableBits.create((int)this.size()));
    }

    private boolean abortableBreadthFirstSearch(int startingNode, boolean up, IntPredicate cons, MutableBits traversed) {
        Bits dests = up ? this.inboundEdges[startingNode] : this.outboundEdges[startingNode];
        boolean any = false;
        int bit = dests.nextSetBit(0);
        while (bit >= 0) {
            if (!traversed.get(bit)) {
                if (!cons.test(bit)) {
                    return true;
                }
                any = true;
            }
            bit = dests.nextSetBit(bit + 1);
        }
        if (!any) {
            return false;
        }
        bit = dests.nextSetBit(0);
        while (bit >= 0) {
            if (!traversed.get(bit)) {
                boolean res = this.abortableBreadthFirstSearch(bit, up, cons, traversed);
                if (res) {
                    return true;
                }
                traversed.set(bit);
            }
            bit = dests.nextSetBit(bit + 1);
        }
        return false;
    }

    private boolean abortableDepthFirstSearch(int startingNode, boolean up, IntPredicate cons, MutableBits traversed) {
        boolean res;
        Bits dests = up ? this.inboundEdges[startingNode] : this.outboundEdges[startingNode];
        boolean any = false;
        int bit = dests.nextSetBit(0);
        while (bit >= 0) {
            if (!traversed.get(bit)) {
                res = this.abortableDepthFirstSearch(bit, up, cons, traversed);
                if (res) {
                    return true;
                }
                any = true;
            }
            bit = dests.nextSetBit(bit + 1);
        }
        if (!any) {
            return false;
        }
        bit = dests.nextSetBit(0);
        while (bit >= 0) {
            if (!traversed.get(bit)) {
                traversed.set(bit);
                res = cons.test(bit);
                if (res) {
                    return true;
                }
            }
            bit = dests.nextSetBit(bit + 1);
        }
        return false;
    }

    @Override
    public Bits connectors() {
        int sz = this.size();
        MutableBits result = MutableBits.create((int)sz);
        for (int i = 0; i < sz; ++i) {
            if (this.inboundEdges[i].isEmpty() || this.outboundEdges[i].isEmpty()) continue;
            result.set(i);
        }
        return result;
    }

    @Override
    public Bits orphans() {
        int sz = this.size();
        MutableBits result = MutableBits.create((int)sz);
        for (int i = 0; i < sz; ++i) {
            if (!this.inboundEdges[i].isEmpty() || !this.outboundEdges[i].isEmpty()) continue;
            result.set(i);
        }
        return result;
    }

    @Override
    public Bits disjointNodes() {
        MutableBits[] unions = new MutableBits[this.size()];
        for (int i = 0; i < unions.length; ++i) {
            unions[i] = MutableBits.create((int)unions.length);
        }
        MutableBits result = MutableBits.create((int)this.size());
        for (int i = 0; i < unions.length; ++i) {
            unions[i] = this._closureOf(i);
            unions[i].clear(i);
            for (int j = 0; j < unions.length; ++j) {
                if (i != j) {
                    unions[i].andNot((Bits)unions[j]);
                }
                if (unions[i].cardinality() != 0) continue;
            }
            if (unions[i].isEmpty()) continue;
            result.set(i);
        }
        return result;
    }

    @Override
    public boolean isRecursive(int node) {
        return this.closureOf(node).get(node);
    }

    @Override
    public boolean isIndirectlyRecursive(int node) {
        MutableBits test = MutableBits.create((int)this.size());
        test.or(this.outboundEdges[node]);
        test.clear(node);
        this.closureOf(node, test, 0);
        return test.get(node);
    }

    @Override
    public int[] byClosureSize() {
        Integer[] result = new Integer[this.outboundEdges.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        int[] cache = new int[result.length];
        Arrays.fill(cache, -1);
        Arrays.sort(result, (a, b) -> {
            int sizeB;
            int sizeA = cache[a] == -1 ? (cache[a.intValue()] = this.closureSize((int)a)) : cache[a];
            int n = sizeB = cache[b] == -1 ? (cache[b.intValue()] = this.closureSize((int)b)) : cache[b];
            return sizeA == sizeB ? 0 : (sizeA > sizeB ? 1 : -1);
        });
        int[] res = new int[result.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = result[i];
        }
        return res;
    }

    @Override
    public int[] byReverseClosureSize() {
        Integer[] result = new Integer[this.outboundEdges.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        int[] cache = new int[this.outboundEdges.length];
        Arrays.fill(cache, -1);
        Arrays.sort(result, (a, b) -> {
            int sizeB;
            int sizeA = cache[a] == -1 ? (cache[a.intValue()] = this.reverseClosureSize((int)a)) : cache[a];
            int n = sizeB = cache[b] == -1 ? (cache[b.intValue()] = this.reverseClosureSize((int)b)) : cache[b];
            return sizeA == sizeB ? 0 : (sizeA > sizeB ? 1 : -1);
        });
        int[] res = new int[result.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = result[i];
        }
        return res;
    }

    public List<int[]> edges() {
        ArrayList<int[]> result = new ArrayList<int[]>();
        for (int i = 0; i < this.outboundEdges.length; ++i) {
            Bits refs = this.outboundEdges[i];
            int bit = refs.nextSetBit(0);
            while (bit >= 0) {
                result.add(new int[]{i, bit});
                bit = refs.nextSetBit(bit + 1);
            }
        }
        return result;
    }

    @Override
    public boolean hasOutboundEdge(int from, int to) {
        return this.outboundEdges[from].get(to);
    }

    @Override
    public boolean hasInboundEdge(int from, int to) {
        return this.inboundEdges[from].get(to);
    }

    @Override
    public int inboundReferenceCount(int node) {
        return this.inboundEdges[node].cardinality();
    }

    @Override
    public int outboundReferenceCount(int node) {
        return this.outboundEdges[node].cardinality();
    }

    @Override
    public Bits children(int node) {
        return this.outboundEdges[node];
    }

    @Override
    public Bits parents(int node) {
        return this.inboundEdges[node];
    }

    private static Bits keySet(Bits[] bits) {
        BitSet nue = new BitSet(bits.length);
        for (int i = 0; i < bits.length; ++i) {
            if (bits[i].cardinality() <= 0) continue;
            nue.set(i);
        }
        return Bits.fromBitSet((BitSet)nue);
    }

    @Override
    public Bits topLevelOrOrphanNodes() {
        return this.topLevel;
    }

    @Override
    public Bits bottomLevelNodes() {
        return this.bottomLevel;
    }

    @Override
    public boolean isUnreferenced(int node) {
        return this.inboundEdges[node].isEmpty();
    }

    @Override
    public int closureSize(int node) {
        return this.closureOf(node).cardinality();
    }

    @Override
    public int reverseClosureSize(int node) {
        return this.reverseClosureOf(node).cardinality();
    }

    @Override
    public Bits closureOf(int node) {
        return this._closureOf(node);
    }

    private MutableBits _closureOf(int node) {
        MutableBits result = MutableBits.create((int)this.size());
        this.closureOf(node, result, 0);
        return result;
    }

    @Override
    public Optional<IntPath> shortestPathBetween(int src, int target) {
        Iterator<IntPath> iter = this.pathsBetween(src, target).iterator();
        return iter.hasNext() ? Optional.of(iter.next()) : Optional.empty();
    }

    @Override
    public Optional<IntPath> shortestUndirectedPathBetween(int src, int target) {
        Iterator<IntPath> iter = this.undirectedPathsBetween(src, target).iterator();
        return iter.hasNext() ? Optional.of(iter.next()) : Optional.empty();
    }

    @Override
    public List<IntPath> pathsBetween(int src, int target) {
        ArrayList<IntPath> paths = new ArrayList<IntPath>();
        IntPath base = new IntPath().add(src);
        PairSet seenPairs = new PairSet(this.size());
        if (this.outboundEdges[src].get(target)) {
            seenPairs.add(src, target);
            paths.add(new IntPath().add(src).add(target));
        }
        this.pathsTo(src, target, base, paths, seenPairs);
        Collections.sort(paths);
        return paths;
    }

    private void pathsTo(int src, int target, IntPath base, List<? super IntPath> paths, PairSet seenPairs) {
        if (src == target) {
            paths.add(base.copy().add(target));
            return;
        }
        this.outboundEdges[src].forEachSetBitAscending(bit -> {
            if (seenPairs.contains(src, bit)) {
                return;
            }
            seenPairs.add(src, bit);
            if (bit == target) {
                IntPath found = base.copy().add(target);
                paths.add(found);
            } else if (!base.contains(bit)) {
                this.pathsTo(bit, target, base.copy().add(bit), paths, seenPairs);
            }
        });
    }

    @Override
    public List<IntPath> undirectedPathsBetween(int src, int target) {
        ArrayList<IntPath> paths = new ArrayList<IntPath>();
        IntPath base = new IntPath().add(src);
        PairSet seenPairs = new PairSet(this.size());
        if (this.neighbors(src).get(target)) {
            seenPairs.add(src, target);
            paths.add(new IntPath().add(src).add(target));
        }
        this.undirectedPathsTo(src, target, base, paths, seenPairs);
        Collections.sort(paths);
        return paths;
    }

    private void undirectedPathsTo(int src, int target, IntPath base, List<? super IntPath> paths, PairSet seenPairs) {
        if (src == target) {
            paths.add(base.copy().add(target));
            return;
        }
        this.neighbors(src).forEachSetBitAscending(bit -> {
            if (seenPairs.contains(src, bit)) {
                return;
            }
            seenPairs.add(src, bit);
            if (bit == target) {
                IntPath found = base.copy().add(target);
                paths.add(found);
            } else if (!base.contains(bit)) {
                this.pathsTo(bit, target, base.copy().add(bit), paths, seenPairs);
            }
        });
    }

    private void closureOf(int node, MutableBits into, int depth) {
        if (into.get(node)) {
            return;
        }
        if (depth > 0) {
            into.set(node);
        }
        this.outboundEdges[node].forEachSetBitAscending(bit -> {
            if (bit != node) {
                this.closureOf(bit, into, depth + 1);
            }
            into.set(bit);
        });
    }

    @Override
    public Bits reverseClosureOf(int node) {
        MutableBits result = MutableBits.create((int)this.size());
        this.reverseClosureOf(node, result, 0);
        return result;
    }

    @Override
    public PairSet toPairSet() {
        PairSet result = new PairSet(this.size());
        for (int i = 0; i < this.size(); ++i) {
            int index = i;
            this.inboundEdges[i].forEachSetBitAscending(bit -> result.add(bit, index));
        }
        return result;
    }

    private void reverseClosureOf(int node, MutableBits into, int depth) {
        if (into.get(node)) {
            return;
        }
        if (depth > 0) {
            into.set(node);
        }
        this.inboundEdges[node].forEachSetBitAscending(bit -> {
            if (bit != node) {
                this.reverseClosureOf(bit, into, depth + 1);
            }
            into.set(bit);
        });
    }

    @Override
    public StringGraph toStringGraph(String[] names) {
        return new BitSetStringGraph(this, names);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Arrays.deepHashCode(this.outboundEdges);
        return hash;
    }

    @Override
    public int totalCardinality() {
        int result = 0;
        for (Bits bs : this.inboundEdges) {
            result += bs.cardinality();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitSetGraph other = (BitSetGraph)obj;
        return Arrays.deepEquals(this.outboundEdges, other.outboundEdges);
    }
}

