/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.graph;

import com.mastfrog.graph.ObjectGraphVisitor;
import com.mastfrog.graph.ObjectPath;
import com.mastfrog.graph.algorithm.RankingAlgorithm;
import com.mastfrog.graph.algorithm.Score;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Set;

public interface ObjectGraph<T> {
    public List<T> byClosureSize();

    public List<T> byReverseClosureSize();

    public Set<String> edgeStrings();

    public Set<T> parents(T var1);

    public Set<T> children(T var1);

    public int inboundReferenceCount(T var1);

    public int outboundReferenceCount(T var1);

    public Set<T> topLevelOrOrphanNodes();

    public Set<T> bottomLevelNodes();

    public boolean isUnreferenced(T var1);

    public int closureSize(T var1);

    public int reverseClosureSize(T var1);

    public Set<T> reverseClosureOf(T var1);

    public Set<T> closureOf(T var1);

    default public void walk(ObjectGraphVisitor<? super T> v) {
        throw new UnsupportedOperationException();
    }

    default public void walk(T startingWith, ObjectGraphVisitor<? super T> v) {
        throw new UnsupportedOperationException();
    }

    default public void walkUpwards(T startingWith, ObjectGraphVisitor<? super T> v) {
        throw new UnsupportedOperationException();
    }

    default public int distance(T a, T b) {
        throw new UnsupportedOperationException();
    }

    default public List<Score<T>> eigenvectorCentrality() {
        throw new UnsupportedOperationException();
    }

    default public List<Score<T>> pageRank() {
        throw new UnsupportedOperationException();
    }

    default public Set<T> disjunctionOfClosureOfHighestRankedNodes() {
        throw new UnsupportedOperationException();
    }

    public void save(ObjectOutput var1) throws IOException;

    public int toNodeId(T var1);

    public T toNode(int var1);

    public List<Score<T>> apply(RankingAlgorithm<?> var1);

    public List<ObjectPath<T>> pathsBetween(T var1, T var2);
}

