/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.interceptors;

import com.mastercard.developer.encryption.EncryptionConfig;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryption;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.encryption.FieldLevelEncryptionParams;
import com.mastercard.developer.interceptors.OpenFeignDecoderExecutor;
import com.mastercard.developer.utils.FeignUtils;
import feign.Response;
import feign.codec.Decoder;

public class OpenFeignFieldLevelEncryptionDecoder
extends OpenFeignDecoderExecutor {
    private final FieldLevelEncryptionConfig config;

    public OpenFeignFieldLevelEncryptionDecoder(EncryptionConfig config, Decoder delegate) {
        super(delegate);
        this.config = (FieldLevelEncryptionConfig)config;
    }

    @Override
    protected String decryptPayload(Response response, String responsePayload) throws EncryptionException {
        if (this.config.useHttpHeaders()) {
            String ivValue = FeignUtils.readHeader(response, this.config.getIvHeaderName());
            String oaepPaddingDigestAlgorithmValue = FeignUtils.readHeader(response, this.config.getOaepPaddingDigestAlgorithmHeaderName());
            String encryptedKeyValue = FeignUtils.readHeader(response, this.config.getEncryptedKeyHeaderName());
            FieldLevelEncryptionParams params = new FieldLevelEncryptionParams(ivValue, encryptedKeyValue, oaepPaddingDigestAlgorithmValue, this.config);
            return FieldLevelEncryption.decryptPayload(responsePayload, this.config, params);
        }
        return FieldLevelEncryption.decryptPayload(responsePayload, this.config);
    }

    @Override
    protected Response removeHeaders(Response response) {
        if (this.config.useHttpHeaders()) {
            response = FeignUtils.removeHeader(response, this.config.getIvHeaderName());
            response = FeignUtils.removeHeader(response, this.config.getOaepPaddingDigestAlgorithmHeaderName());
            response = FeignUtils.removeHeader(response, this.config.getEncryptedKeyHeaderName());
            response = FeignUtils.removeHeader(response, this.config.getEncryptionCertificateFingerprintHeaderName());
            return FeignUtils.removeHeader(response, this.config.getEncryptionKeyFingerprintHeaderName());
        }
        return response;
    }
}

