/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.api.mastercom;

import com.mastercard.api.core.exception.ApiException;
import com.mastercard.api.core.model.Action;
import com.mastercard.api.core.model.BaseObject;
import com.mastercard.api.core.model.OperationConfig;
import com.mastercard.api.core.model.OperationMetadata;
import com.mastercard.api.core.model.RequestMap;
import com.mastercard.api.core.security.Authentication;
import com.mastercard.api.mastercom.ResourceConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Transactions
extends BaseObject {
    private static Map<String, OperationConfig> operationConfigs = new HashMap<String, OperationConfig>();

    public Transactions() {
    }

    public Transactions(BaseObject o) {
        this.putAll((Map)o);
    }

    public Transactions(RequestMap requestMap) {
        this.putAll((Map)requestMap);
    }

    protected final OperationConfig getOperationConfig(String operationUUID) throws IllegalArgumentException {
        OperationConfig operationConfig = operationConfigs.get(operationUUID);
        if (operationConfig == null) {
            throw new IllegalArgumentException("Invalid operationUUID supplied: " + operationUUID);
        }
        return operationConfig;
    }

    protected OperationMetadata getOperationMetadata() throws IllegalArgumentException {
        return new OperationMetadata(ResourceConfig.getInstance().getVersion(), ResourceConfig.getInstance().getHost(), ResourceConfig.getInstance().getContext(), ResourceConfig.getInstance().getJsonNative(), ResourceConfig.getInstance().getContentTypeOverride());
    }

    public static Transactions retrieveClearingDetail(String id) throws ApiException {
        return Transactions.retrieveClearingDetail(null, id, null);
    }

    public static Transactions retrieveClearingDetail(String id, RequestMap map) throws ApiException {
        return Transactions.retrieveClearingDetail(null, id, map);
    }

    public static Transactions retrieveClearingDetail(Authentication auth, String id) throws ApiException {
        return Transactions.retrieveClearingDetail(auth, id, null);
    }

    public static Transactions retrieveClearingDetail(Authentication auth, String id, RequestMap map) throws ApiException {
        Transactions val = new Transactions();
        if (id != null) {
            val.put("id", id);
        }
        if (map != null) {
            val.putAll((Map)map);
        }
        return new Transactions(BaseObject.executeOperation((Authentication)auth, (String)"d49706e7-23fe-4be2-a932-363550db8fc1", (BaseObject)val));
    }

    public static Transactions retrieveAuthorizationDetail(String id) throws ApiException {
        return Transactions.retrieveAuthorizationDetail(null, id, null);
    }

    public static Transactions retrieveAuthorizationDetail(String id, RequestMap map) throws ApiException {
        return Transactions.retrieveAuthorizationDetail(null, id, map);
    }

    public static Transactions retrieveAuthorizationDetail(Authentication auth, String id) throws ApiException {
        return Transactions.retrieveAuthorizationDetail(auth, id, null);
    }

    public static Transactions retrieveAuthorizationDetail(Authentication auth, String id, RequestMap map) throws ApiException {
        Transactions val = new Transactions();
        if (id != null) {
            val.put("id", id);
        }
        if (map != null) {
            val.putAll((Map)map);
        }
        return new Transactions(BaseObject.executeOperation((Authentication)auth, (String)"c14dbcf5-4208-406c-932a-bbb4d621f5e4", (BaseObject)val));
    }

    public static Transactions searchForTransaction(RequestMap map) throws ApiException {
        return Transactions.searchForTransaction(null, map);
    }

    public static Transactions searchForTransaction(Authentication auth, RequestMap map) throws ApiException {
        return new Transactions(BaseObject.executeOperation((Authentication)auth, (String)"84c5673d-2b48-41af-b28d-6229c6b41686", (BaseObject)new Transactions(map)));
    }

    static {
        operationConfigs.put("d49706e7-23fe-4be2-a932-363550db8fc1", new OperationConfig("/mastercom/v6/claims/{claim-id}/transactions/clearing/{transaction-id}", Action.read, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("c14dbcf5-4208-406c-932a-bbb4d621f5e4", new OperationConfig("/mastercom/v6/claims/{claim-id}/transactions/authorization/{transaction-id}", Action.read, Arrays.asList(""), Arrays.asList("")));
        operationConfigs.put("84c5673d-2b48-41af-b28d-6229c6b41686", new OperationConfig("/mastercom/v6/transactions/search", Action.create, Arrays.asList(""), Arrays.asList("")));
    }
}

