/*
 * Decompiled with CFR 0.152.
 */
package dnl.utils.text.table;

import dnl.utils.text.table.SeparatorPolicy;
import dnl.utils.text.table.TextTableRenderer;
import dnl.utils.text.table.csv.CsvTableRenderer;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class TextTable {
    protected TableModel tableModel;
    protected List<SeparatorPolicy> separatorPolicies = new ArrayList<SeparatorPolicy>();
    protected boolean addRowNumbering;
    protected RowSorter<?> rowSorter;
    protected boolean headless;

    public TextTable(TableModel tableModel) {
        this.tableModel = tableModel;
    }

    public TextTable(TableModel tableModel, boolean addNumbering) {
        this.tableModel = tableModel;
        this.addRowNumbering = addNumbering;
    }

    public TextTable(String[] columnNames, Object[][] data) {
        this.tableModel = new DefaultTableModel(data, columnNames);
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setAddRowNumbering(boolean addNumbering) {
        this.addRowNumbering = addNumbering;
    }

    public void addSeparatorPolicy(SeparatorPolicy separatorPolicy) {
        this.separatorPolicies.add(separatorPolicy);
        separatorPolicy.setTableModel(this.tableModel);
    }

    public void setSort(int column) {
        this.setSort(column, SortOrder.ASCENDING);
    }

    public void setSort(int column, SortOrder sortOrder) {
        this.rowSorter = new TableRowSorter<TableModel>(this.tableModel);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(column, sortOrder));
        this.rowSorter.setSortKeys(sortKeys);
    }

    public void printTable() {
        this.printTable(System.out, 0);
    }

    public void printTable(PrintStream ps, int indent) {
        TextTableRenderer renderer = new TextTableRenderer(this);
        renderer.render(ps, indent);
    }

    public void toCsv(OutputStream os) {
        CsvTableRenderer csvTableRenderer = new CsvTableRenderer(this);
        csvTableRenderer.render(os, 0);
    }

    protected Object getValueAt(int row, int column) {
        int rowIndex = row;
        if (this.rowSorter != null) {
            rowIndex = this.rowSorter.convertRowIndexToModel(row);
        }
        return this.tableModel.getValueAt(rowIndex, column);
    }

    protected boolean hasSeparatorAt(int row) {
        for (SeparatorPolicy separatorPolicy : this.separatorPolicies) {
            if (!separatorPolicy.hasSeparatorAt(row)) continue;
            return true;
        }
        return false;
    }
}

