/*
 * Decompiled with CFR 0.152.
 */
package com.mashape.unirest.http;

import com.mashape.unirest.http.Headers;
import com.mashape.unirest.http.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponse<T> {
    private int code;
    private Headers headers;
    private InputStream rawBody;
    private T body;

    private boolean isGzipped() {
        String contentEncoding = this.headers.getFirst("content-encoding");
        return contentEncoding != null && "gzip".equals(contentEncoding.toLowerCase().trim());
    }

    public HttpResponse(org.apache.http.HttpResponse response, Class<T> responseClass) {
        block11: {
            Header[] allHeaders;
            this.headers = new Headers();
            HttpEntity responseEntity = response.getEntity();
            for (Header header : allHeaders = response.getAllHeaders()) {
                String headerName = header.getName().toLowerCase();
                ArrayList<String> list = (ArrayList<String>)this.headers.get(headerName);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(header.getValue());
                this.headers.put(headerName, list);
            }
            this.code = response.getStatusLine().getStatusCode();
            if (responseEntity != null) {
                try {
                    byte[] rawBody;
                    try {
                        InputStream responseInputStream = responseEntity.getContent();
                        if (this.isGzipped()) {
                            responseInputStream = new GZIPInputStream(responseEntity.getContent());
                        }
                        rawBody = HttpResponse.getBytes(responseInputStream);
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(rawBody);
                    this.rawBody = inputStream;
                    if (JsonNode.class.equals(responseClass)) {
                        String jsonString = new String(rawBody).trim();
                        this.body = new JsonNode(jsonString);
                        break block11;
                    }
                    if (String.class.equals(responseClass)) {
                        this.body = new String(rawBody);
                        break block11;
                    }
                    if (InputStream.class.equals(responseClass)) {
                        this.body = this.rawBody;
                        break block11;
                    }
                    throw new Exception("Unknown result type. Only String, JsonNode and InputStream are supported.");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static byte[] getBytes(InputStream is) throws IOException {
        byte[] buf;
        int size = 1024;
        if (is instanceof ByteArrayInputStream) {
            size = is.available();
            buf = new byte[size];
            int len = is.read(buf, 0, size);
        } else {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            buf = new byte[size];
            while ((len = is.read(buf, 0, size)) != -1) {
                bos.write(buf, 0, len);
            }
            buf = bos.toByteArray();
        }
        return buf;
    }

    public int getCode() {
        return this.code;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public InputStream getRawBody() {
        return this.rawBody;
    }

    public T getBody() {
        return this.body;
    }
}

