/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.rest.util;

import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.extra.okhttpclient.OkHttpClientBuilderFactory;
import com.marklogic.rest.util.HttpClientBuilderConfigurer;
import com.marklogic.rest.util.MgmtResponseErrorHandler;
import com.marklogic.rest.util.RestConfig;
import com.marklogic.rest.util.configurer.BasicAuthConfigurer;
import com.marklogic.rest.util.configurer.NoConnectionReuseConfigurer;
import com.marklogic.rest.util.configurer.SslConfigurer;
import com.marklogic.rest.util.configurer.UseSystemPropertiesConfigurer;
import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtil {
    private static final Logger logger = LoggerFactory.getLogger(RestTemplateUtil.class);
    @Deprecated
    public static List<HttpClientBuilderConfigurer> DEFAULT_CONFIGURERS = new ArrayList<HttpClientBuilderConfigurer>();

    @Deprecated
    public static RestTemplate newRestTemplate(String host, int port, String username, String password) {
        return RestTemplateUtil.newRestTemplate(new RestConfig(host, port, username, password));
    }

    public static RestTemplate newRestTemplate(RestConfig config) {
        OkHttpClient client;
        try {
            DatabaseClientFactory.Bean bean = config.newDatabaseClientBuilder().buildBean();
            client = OkHttpClientBuilderFactory.newOkHttpClientBuilder((String)bean.getHost(), (DatabaseClientFactory.SecurityContext)bean.getSecurityContext()).build();
        }
        catch (RuntimeException ex) {
            throw new RuntimeException(String.format("Unable to connect to the MarkLogic app server at %s; cause: %s", config.toString(), ex.getMessage()));
        }
        RestTemplate rt = new RestTemplate((ClientHttpRequestFactory)new OkHttp3ClientHttpRequestFactory(client));
        rt.setErrorHandler((ResponseErrorHandler)new MgmtResponseErrorHandler());
        return rt;
    }

    @Deprecated
    public static RestTemplate newRestTemplate(String host, int port, String username, String password, HttpClientBuilderConfigurer ... configurers) {
        return RestTemplateUtil.newRestTemplate(new RestConfig(host, port, username, password), configurers);
    }

    @Deprecated
    public static RestTemplate newRestTemplate(RestConfig config, List<HttpClientBuilderConfigurer> configurers) {
        return RestTemplateUtil.newRestTemplate(config, configurers.toArray(new HttpClientBuilderConfigurer[0]));
    }

    @Deprecated
    public static RestTemplate newRestTemplate(RestConfig config, HttpClientBuilderConfigurer ... configurers) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (configurers != null) {
            for (HttpClientBuilderConfigurer configurer : configurers) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Applying HttpClientBuilderConfigurer: " + configurer);
                }
                httpClientBuilder = configurer.configureHttpClientBuilder(config, httpClientBuilder);
            }
        }
        CloseableHttpClient client = httpClientBuilder.build();
        RestTemplate rt = new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)client));
        rt.setErrorHandler((ResponseErrorHandler)new MgmtResponseErrorHandler());
        return rt;
    }

    static {
        DEFAULT_CONFIGURERS.add(new BasicAuthConfigurer());
        DEFAULT_CONFIGURERS.add(new SslConfigurer());
        DEFAULT_CONFIGURERS.add(new NoConnectionReuseConfigurer());
        DEFAULT_CONFIGURERS.add(new UseSystemPropertiesConfigurer());
    }
}

