/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.rest.util;

import com.marklogic.client.DatabaseClientBuilder;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.ext.modulesloader.ssl.SimpleX509TrustManager;
import com.marklogic.client.ext.ssl.SslConfig;
import com.marklogic.client.ext.ssl.SslUtil;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.springframework.util.StringUtils;

public class RestConfig {
    private String host;
    private int port;
    private String authType = "digest";
    private String username;
    private String password;
    private String cloudApiKey;
    private String certFile;
    private String certPassword;
    private String externalName;
    private String samlToken;
    private String basePath;
    private String scheme = "http";
    private boolean configureSimpleSsl;
    private boolean useDefaultKeystore;
    private String sslProtocol;
    private String trustManagementAlgorithm;
    private DatabaseClientFactory.SSLHostnameVerifier sslHostnameVerifier;
    private SSLContext sslContext;
    @Deprecated
    private X509HostnameVerifier hostnameVerifier;
    private String keyStorePath;
    private String keyStorePassword;
    private String keyStoreType;
    private String keyStoreAlgorithm;
    private String trustStorePath;
    private String trustStorePassword;
    private String trustStoreType;
    private String trustStoreAlgorithm;

    public RestConfig() {
    }

    public RestConfig(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public RestConfig(RestConfig other) {
        this(other.host, other.port, other.username, other.password);
        if (other.scheme != null) {
            this.scheme = other.scheme;
        }
        this.cloudApiKey = other.cloudApiKey;
        this.basePath = other.basePath;
        this.authType = other.authType;
        this.certFile = other.certFile;
        this.certPassword = other.certPassword;
        this.externalName = other.externalName;
        this.samlToken = other.samlToken;
        this.configureSimpleSsl = other.configureSimpleSsl;
        this.useDefaultKeystore = other.useDefaultKeystore;
        this.sslProtocol = other.sslProtocol;
        this.trustManagementAlgorithm = other.trustManagementAlgorithm;
        this.sslContext = other.sslContext;
        this.hostnameVerifier = other.hostnameVerifier;
        this.sslHostnameVerifier = other.sslHostnameVerifier;
        this.keyStorePath = other.keyStorePath;
        this.keyStorePassword = other.keyStorePassword;
        this.keyStoreAlgorithm = other.keyStoreAlgorithm;
        this.keyStoreType = other.keyStoreType;
        this.trustStorePath = other.trustStorePath;
        this.trustStorePassword = other.trustStorePassword;
        this.trustStoreType = other.trustStoreType;
        this.trustStoreAlgorithm = other.trustStoreAlgorithm;
    }

    public DatabaseClientBuilder newDatabaseClientBuilder() {
        DatabaseClientBuilder builder = new DatabaseClientBuilder().withHost(this.getHost()).withPort(this.getPort()).withBasePath(this.getBasePath()).withAuthType(this.getAuthType()).withUsername(this.getUsername()).withPassword(this.getPassword()).withCloudApiKey(this.getCloudApiKey()).withCertificateFile(this.getCertFile()).withCertificatePassword(this.getCertPassword()).withKerberosPrincipal(this.getExternalName()).withSAMLToken(this.getSamlToken()).withSSLHostnameVerifier(this.getSslHostnameVerifier()).withKeyStorePath(this.getKeyStorePath()).withKeyStorePassword(this.getKeyStorePassword()).withKeyStoreType(this.getKeyStoreType()).withKeyStoreAlgorithm(this.getKeyStoreAlgorithm()).withTrustStorePath(this.getTrustStorePath()).withTrustStorePassword(this.getTrustStorePassword()).withTrustStoreType(this.getTrustStoreType()).withTrustStoreAlgorithm(this.getTrustStoreAlgorithm());
        if (this.getSslContext() != null) {
            builder.withSSLContext(this.getSslContext());
        } else {
            String sslProtocol = this.getSslProtocol();
            if (this.isUseDefaultKeystore()) {
                sslProtocol = StringUtils.hasText((String)sslProtocol) ? sslProtocol : "TLSv1.2";
                SslConfig sslConfig = SslUtil.configureUsingTrustManagerFactory((String)sslProtocol, (String)this.getTrustManagementAlgorithm());
                builder.withSSLContext(sslConfig.getSslContext()).withTrustManager(sslConfig.getTrustManager());
            } else if (this.isConfigureSimpleSsl()) {
                builder.withSSLContext(StringUtils.hasText((String)sslProtocol) ? SimpleX509TrustManager.newSSLContext((String)sslProtocol) : SimpleX509TrustManager.newSSLContext()).withTrustManager((X509TrustManager)new SimpleX509TrustManager()).withSSLHostnameVerifier((DatabaseClientFactory.SSLHostnameVerifier)DatabaseClientFactory.SSLHostnameVerifier.ANY);
            } else {
                builder.withSSLProtocol(sslProtocol);
            }
        }
        return builder;
    }

    public String toString() {
        return String.format("%s://%s:%d", this.getScheme(), this.getHost(), this.getPort());
    }

    public URI buildUri(String path) {
        String basePathToAppend = "";
        if (this.basePath != null) {
            if (!this.basePath.startsWith("/")) {
                basePathToAppend = "/";
            }
            basePathToAppend = basePathToAppend + this.basePath;
            if (path.startsWith("/") && basePathToAppend.endsWith("/")) {
                basePathToAppend = basePathToAppend.substring(0, basePathToAppend.length() - 1);
            }
        }
        try {
            return new URI(String.format("%s://%s:%d%s%s", this.getScheme(), this.getHost(), this.getPort(), basePathToAppend, path.replace(" ", "+")));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Unable to build URI for path: " + path + "; cause: " + ex.getMessage(), ex);
        }
    }

    public String getBaseUrl() {
        return String.format("%s://%s:%d", this.scheme, this.host, this.port);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean isConfigureSimpleSsl() {
        return this.configureSimpleSsl;
    }

    public void setConfigureSimpleSsl(boolean configureSimpleSsl) {
        this.configureSimpleSsl = configureSimpleSsl;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Deprecated
    public X509HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Deprecated
    public void setHostnameVerifier(X509HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getTrustManagementAlgorithm() {
        return this.trustManagementAlgorithm;
    }

    public void setTrustManagementAlgorithm(String trustManagementAlgorithm) {
        this.trustManagementAlgorithm = trustManagementAlgorithm;
    }

    public boolean isUseDefaultKeystore() {
        return this.useDefaultKeystore;
    }

    public void setUseDefaultKeystore(boolean useDefaultKeystore) {
        this.useDefaultKeystore = useDefaultKeystore;
    }

    public DatabaseClientFactory.SSLHostnameVerifier getSslHostnameVerifier() {
        return this.sslHostnameVerifier;
    }

    public void setSslHostnameVerifier(DatabaseClientFactory.SSLHostnameVerifier sslHostnameVerifier) {
        this.sslHostnameVerifier = sslHostnameVerifier;
    }

    public String getCloudApiKey() {
        return this.cloudApiKey;
    }

    public void setCloudApiKey(String cloudApiKey) {
        this.cloudApiKey = cloudApiKey;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getCertFile() {
        return this.certFile;
    }

    public void setCertFile(String certFile) {
        this.certFile = certFile;
    }

    public String getCertPassword() {
        return this.certPassword;
    }

    public void setCertPassword(String certPassword) {
        this.certPassword = certPassword;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public void setExternalName(String externalName) {
        this.externalName = externalName;
    }

    public String getSamlToken() {
        return this.samlToken;
    }

    public void setSamlToken(String samlToken) {
        this.samlToken = samlToken;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreAlgorithm() {
        return this.keyStoreAlgorithm;
    }

    public void setKeyStoreAlgorithm(String keyStoreAlgorithm) {
        this.keyStoreAlgorithm = keyStoreAlgorithm;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getTrustStoreAlgorithm() {
        return this.trustStoreAlgorithm;
    }

    public void setTrustStoreAlgorithm(String trustStoreAlgorithm) {
        this.trustStoreAlgorithm = trustStoreAlgorithm;
    }
}

