/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.rest.util;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

public class MgmtResponseErrorHandler
extends DefaultResponseErrorHandler {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static boolean errorLoggingEnabled = true;

    public void handleError(ClientHttpResponse response) throws IOException {
        try {
            super.handleError(response);
        }
        catch (HttpClientErrorException | HttpServerErrorException ex) {
            String message = "Logging HTTP response body to assist with debugging: " + ex.getResponseBodyAsString();
            if (HttpStatus.SERVICE_UNAVAILABLE.equals((Object)ex.getStatusCode())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(message);
                }
            } else if (this.logger.isErrorEnabled() && errorLoggingEnabled) {
                this.logger.error(message);
            }
            throw ex;
        }
        catch (InvalidMediaTypeException ex) {
            String body = new String(this.getResponseBody(response));
            throw new RuntimeException("Unable to parse mime type: " + ex.getMessage() + "; response body from MarkLogic: " + body);
        }
    }
}

