/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.util;

import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.util.PropertySource;
import com.marklogic.mgmt.util.SystemPropertySource;
import org.springframework.util.StringUtils;

public abstract class PropertySourceFactory
extends LoggingObject {
    private PropertySource propertySource;
    private boolean checkWithMarklogicPrefix = true;

    protected PropertySourceFactory() {
        this(new SystemPropertySource());
    }

    public PropertySourceFactory(PropertySource propertySource) {
        this.propertySource = propertySource;
    }

    protected String getProperty(String name) {
        String val = this.propertySource.getProperty(name);
        if (val != null) {
            return val.trim();
        }
        if (this.checkWithMarklogicPrefix) {
            val = this.propertySource.getProperty("marklogic." + name);
            return val != null ? val.trim() : val;
        }
        return null;
    }

    protected boolean propertyExists(String name) {
        return StringUtils.hasText((String)this.propertySource.getProperty(name));
    }

    public void setPropertySource(PropertySource propertySource) {
        this.propertySource = propertySource;
    }

    public boolean isCheckWithMarklogicPrefix() {
        return this.checkWithMarklogicPrefix;
    }

    public void setCheckWithMarklogicPrefix(boolean applyMarklogicPrefix) {
        this.checkWithMarklogicPrefix = applyMarklogicPrefix;
    }

    public PropertySource getPropertySource() {
        return this.propertySource;
    }

    protected final Integer propertyToInteger(String propertyName, String propertyValue) {
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(this.format("The property %s requires a numeric value; invalid value: \u2018%s'", new Object[]{propertyName, propertyValue}));
        }
    }
}

