/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.selector;

import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.appservers.ServerManager;
import com.marklogic.mgmt.resource.cpf.CpfConfigManager;
import com.marklogic.mgmt.resource.cpf.DomainManager;
import com.marklogic.mgmt.resource.cpf.PipelineManager;
import com.marklogic.mgmt.resource.databases.DatabaseManager;
import com.marklogic.mgmt.resource.groups.GroupManager;
import com.marklogic.mgmt.resource.security.AmpManager;
import com.marklogic.mgmt.resource.security.PrivilegeManager;
import com.marklogic.mgmt.resource.security.RoleManager;
import com.marklogic.mgmt.resource.security.UserManager;
import com.marklogic.mgmt.resource.tasks.TaskManager;
import com.marklogic.mgmt.resource.triggers.TriggerManager;
import com.marklogic.mgmt.selector.MapResourceSelection;
import com.marklogic.mgmt.selector.ResourceSelection;
import com.marklogic.mgmt.selector.ResourceSelector;
import com.marklogic.rest.util.ResourcesFragment;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class AbstractNameMatchingResourceSelector
implements ResourceSelector {
    private List<String> includeTypes;
    private String triggersDatabase;

    protected abstract boolean nameMatches(String var1);

    @Override
    public ResourceSelection selectResources(ManageClient manageClient) {
        MapResourceSelection selection = new MapResourceSelection();
        this.select(selection, new ServerManager(manageClient), "servers");
        this.select(selection, new DatabaseManager(manageClient), "databases");
        this.select(selection, new RoleManager(manageClient), "roles");
        this.select(selection, new UserManager(manageClient), "users");
        this.select(selection, new GroupManager(manageClient), "groups");
        if (this.triggersDatabase != null) {
            this.select(selection, new CpfConfigManager(manageClient, this.triggersDatabase), "cpfConfigs");
            this.select(selection, new DomainManager(manageClient, this.triggersDatabase), "domains");
            this.select(selection, new PipelineManager(manageClient, this.triggersDatabase), "pipelines");
            this.select(selection, new TriggerManager(manageClient, this.triggersDatabase), "triggers");
        }
        this.selectPrivileges(selection, manageClient);
        this.selectTasks(selection, manageClient);
        this.selectAmps(selection, manageClient);
        return selection;
    }

    protected void selectAmps(MapResourceSelection selection, ManageClient manageClient) {
        if (this.includeTypes == null || this.includeTypes.contains("amps")) {
            AmpManager mgr = new AmpManager(manageClient);
            ResourcesFragment amps = mgr.getAsXml();
            Namespace ns = Namespace.getNamespace((String)"http://marklogic.com/manage/security");
            for (Element amp : amps.getListItems()) {
                String nameref = amp.getChildText("nameref", ns);
                if (!this.nameMatches(nameref)) continue;
                String uriref = amp.getChildText("uriref", ns);
                selection.select("amps", uriref);
            }
        }
    }

    protected void selectTasks(MapResourceSelection selection, ManageClient manageClient) {
        if (this.includeTypes == null || this.includeTypes.contains("tasks")) {
            TaskManager taskManager = new TaskManager(manageClient);
            for (String path : taskManager.getTaskPaths()) {
                if (!this.nameMatches(path)) continue;
                selection.select("tasks", path);
            }
        }
    }

    protected void selectPrivileges(MapResourceSelection selection, ManageClient manageClient) {
        if (this.includeTypes == null || this.includeTypes.contains("privilegesExecute") || this.includeTypes.contains("privilegesUri")) {
            PrivilegeManager privilegeManager = new PrivilegeManager(manageClient);
            ResourcesFragment privileges = privilegeManager.getAsXml();
            for (String name : privileges.getListItemNameRefs()) {
                if (!this.nameMatches(name)) continue;
                String kind = privileges.getListItemValue(name, "kind");
                if ("uri".equals(kind)) {
                    selection.select("privilegesUri", name);
                    continue;
                }
                selection.select("privilegesExecute", name);
            }
        }
    }

    protected void select(MapResourceSelection selection, ResourceManager mgr, String type) {
        if (this.includeTypes == null || this.includeTypes.contains(type)) {
            ResourcesFragment resources = mgr.getAsXml();
            for (String name : resources.getListItemNameRefs()) {
                if (!this.nameMatches(name)) continue;
                selection.select(type, name);
            }
        }
    }

    public void setIncludeTypesAsString(String commaDelimitedTypes) {
        if (commaDelimitedTypes != null) {
            this.setIncludeTypes(commaDelimitedTypes.split(","));
        }
    }

    public void setIncludeTypes(String ... types) {
        this.includeTypes = new ArrayList<String>();
        for (String type : types) {
            if ("privileges".equals(type)) {
                this.includeTypes.add("privilegesExecute");
                this.includeTypes.add("privilegesUri");
                continue;
            }
            this.includeTypes.add(type);
        }
    }

    public String getTriggersDatabase() {
        return this.triggersDatabase;
    }

    public void setTriggersDatabase(String triggersDatabase) {
        this.triggersDatabase = triggersDatabase;
    }
}

