/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.tasks;

import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.SaveReceipt;
import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.task.Task;
import com.marklogic.mgmt.resource.AbstractResourceManager;
import com.marklogic.mgmt.resource.requests.RequestManager;
import com.marklogic.rest.util.Fragment;
import com.marklogic.rest.util.ResourcesFragment;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class TaskManager
extends AbstractResourceManager {
    private String groupName = "Default";

    public TaskManager(ManageClient client) {
        super(client);
    }

    public TaskManager(ManageClient client, String groupName) {
        super(client);
        this.groupName = groupName;
    }

    @Override
    protected String getResourceId(String payload) {
        String taskId = this.payloadParser.getPayloadFieldValue(payload, "task-id", false);
        if (taskId != null) {
            return taskId;
        }
        String taskPath = this.payloadParser.getPayloadFieldValue(payload, "task-path");
        String taskDatabase = this.payloadParser.getPayloadFieldValue(payload, "task-database", false);
        String xpath = taskDatabase != null ? this.format("/t:tasks-default-list/t:list-items/t:list-item[t:task-path = '%s' and t:task-database = '%s']/t:idref", new Object[]{taskPath, taskDatabase}) : this.format("/t:tasks-default-list/t:list-items/t:list-item[t:task-path = '%s']/t:idref", new Object[]{taskPath});
        List<String> resourceIds = this.getAsXml().getElementValues(xpath);
        if (resourceIds == null || resourceIds.isEmpty()) {
            return null;
        }
        String taskRoot = this.payloadParser.getPayloadFieldValue(payload, "task-root", false);
        if (taskRoot == null) {
            throw new RuntimeException("Unable to determine ID for task, as multiple existing tasks have the same task-path and task-database, but payload is missing a task-root to determine which existing task is the same root; payload: " + payload);
        }
        for (String resourceId : resourceIds) {
            String json = this.getManageClient().getJson(this.appendGroupId(super.getResourcesPath() + "/" + resourceId + "/properties"));
            String thisTaskRoot = this.payloadParser.getPayloadFieldValue(json, "task-root", false);
            if (!taskRoot.equals(thisTaskRoot)) continue;
            return resourceId;
        }
        return null;
    }

    @Override
    public String getResourcesPath() {
        return this.appendGroupId(super.getResourcesPath());
    }

    protected String appendGroupId(String path) {
        if (this.groupName != null) {
            if (path.contains("?")) {
                return path + "&group-id=" + this.groupName;
            }
            return path + "?group-id=" + this.groupName;
        }
        return path;
    }

    @Override
    public String getResourcePath(String resourceNameOrId, String ... resourceUrlParams) {
        return super.getResourcesPath() + "/" + this.getTaskIdForTaskPath(resourceNameOrId);
    }

    @Override
    protected String[] getUpdateResourceParams(String payload) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("group-id");
        params.add(this.groupName);
        return params.toArray(new String[0]);
    }

    @Override
    protected String getIdFieldName() {
        return "task-id";
    }

    public String getTaskIdForTaskPath(String taskPathOrTaskId) {
        ResourcesFragment f = this.getAsXml();
        String xpath = "/t:tasks-default-list/t:list-items/t:list-item[t:task-path = '%s' or t:idref = '%s']/t:idref";
        List<String> resourceIds = f.getElementValues(xpath = String.format(xpath, taskPathOrTaskId, taskPathOrTaskId));
        if (resourceIds == null || resourceIds.isEmpty()) {
            throw new RuntimeException("Could not find a scheduled task with a task-path or task-id of: " + taskPathOrTaskId);
        }
        if (resourceIds.size() == 1) {
            return resourceIds.get(0);
        }
        throw new RuntimeException(this.format("Found multiple task IDs with the same task-path of %s; IDs: %s", new Object[]{taskPathOrTaskId, resourceIds}));
    }

    @Override
    public boolean exists(String resourceNameOrId, String ... resourceUrlParams) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Checking for existence of resource: " + resourceNameOrId);
        }
        ResourcesFragment f = this.getAsXml();
        return f.elementExists(this.format("/t:tasks-default-list/t:list-items/t:list-item[t:task-path = '%s' or t:idref = '%s']", new Object[]{resourceNameOrId, resourceNameOrId}));
    }

    @Override
    protected SaveReceipt createNewResource(String payload, String resourceId) {
        String taskPath = this.payloadParser.getPayloadFieldValue(payload, "task-path", false);
        SaveReceipt receipt = super.createNewResource(payload, taskPath);
        this.updateNewTaskIfItShouldBeDisabled(payload, receipt);
        return receipt;
    }

    protected void updateNewTaskIfItShouldBeDisabled(String payload, SaveReceipt receipt) {
        String enabled = this.payloadParser.getPayloadFieldValue(payload, "task-enabled", false);
        if ("false".equalsIgnoreCase(enabled)) {
            URI uri = receipt.getResponse().getHeaders().getLocation();
            String[] tokens = uri.getPath().split("/");
            String taskId = tokens[tokens.length - 1];
            Task task = new Task(new API(this.getManageClient()), taskId);
            task.setTaskEnabled(false);
            String path = this.getPropertiesPath(taskId, new String[0]);
            path = this.appendParamsAndValuesToPath(path, this.getUpdateResourceParams(payload));
            this.logger.info("Updating new scheduled task so it is disabled; task ID: " + taskId);
            this.putPayload(this.getManageClient(), path, task.getJson());
        }
    }

    @Override
    public SaveReceipt updateResource(String payload, String resourceId) {
        this.logger.info("Deleting scheduled task first since updates are not allowed except for task-enabled; task ID: " + resourceId);
        this.deleteByIdField(resourceId, new String[0]);
        PayloadParser parser = new PayloadParser();
        payload = parser.excludeProperties(payload, "task-id");
        String taskPath = parser.getPayloadFieldValue(payload, "task-path");
        SaveReceipt receipt = super.createNewResource(payload, taskPath);
        this.updateNewTaskIfItShouldBeDisabled(payload, receipt);
        return receipt;
    }

    public List<String> getTaskPaths() {
        return this.getAsXml().getListItemValues("task-path");
    }

    public void disableAllTasks() {
        for (String id : this.getAsXml().getListItemIdRefs()) {
            this.disableTask(id);
        }
    }

    public void enableAllTasks() {
        for (String id : this.getAsXml().getListItemIdRefs()) {
            this.enableTask(id);
        }
    }

    public void disableTask(String taskId) {
        String json = this.format("{\"task-id\":\"%s\", \"task-enabled\":false}", new Object[]{taskId});
        String path = this.appendGroupId(super.getResourcesPath() + "/" + taskId + "/properties");
        this.putPayload(this.getManageClient(), path, json);
    }

    public void enableTask(String taskId) {
        String json = this.format("{\"task-id\":\"%s\", \"task-enabled\":true}", new Object[]{taskId});
        String path = this.appendGroupId(super.getResourcesPath() + "/" + taskId + "/properties");
        this.putPayload(this.getManageClient(), path, json);
    }

    public void deleteAllTasks() {
        this.deleteAllScheduledTasks();
    }

    @Deprecated
    public void deleteTaskWithPath(String taskPath) {
        this.deleteTaskWithPath(taskPath, "/");
    }

    public void deleteTaskWithPath(String taskPath, String taskRoot) {
        String json = this.format("{\"task-path\":\"%s\", \"task-root\":\"%s\"}", new Object[]{taskPath, taskRoot});
        this.delete(json, "group-id", this.groupName);
    }

    public String getTaskId(String taskPath) {
        return this.getAsXml().getElementValue(this.format("/t:tasks-default-list/t:list-items/t:list-item[t:task-path = '%s']/t:idref", new Object[]{taskPath}));
    }

    public void deleteAllScheduledTasks() {
        for (String id : this.getAsXml().getListItemIdRefs()) {
            this.deleteAtPath(this.appendGroupId(super.getResourcesPath() + "/" + id), new String[0]);
        }
    }

    public void waitForTasksToComplete(String group, int retryInMilliseconds) {
        Fragment servers = this.getManageClient().getXml("/manage/v2/task-servers", new String[0]);
        String taskServerId = servers.getElementValue(this.format("//ts:list-item[ts:groupnameref = '%s']/ts:idref", new Object[]{group}));
        if (taskServerId == null) {
            this.logger.warn(this.format("Could not find task server ID for group %s, so not waiting for tasks to complete", new Object[]{group}));
            return;
        }
        RequestManager mgr = new RequestManager(this.getManageClient());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Waiting for tasks to complete on task server");
        }
        int count = mgr.getRequestCountForRelationId(taskServerId);
        while (count > 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Waiting for tasks to complete on task server, count: " + count);
            }
            try {
                Thread.sleep(retryInMilliseconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            count = mgr.getRequestCountForRelationId(taskServerId);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Finished waiting for tasks to complete on task server");
        }
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }
}

