/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.resource.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.AbstractResourceManager;
import com.marklogic.rest.util.ResourcesFragment;
import org.apache.commons.lang3.StringUtils;

public class QueryRolesetManager
extends AbstractResourceManager {
    public QueryRolesetManager(ManageClient client) {
        super(client);
        this.setUpdateAllowed(false);
    }

    @Override
    protected boolean useSecurityUser() {
        return true;
    }

    @Override
    public String getResourcesPath() {
        return "/manage/v2/query-rolesets";
    }

    @Override
    protected String getResourceName() {
        return "query-rolesets";
    }

    @Override
    protected String getIdFieldName() {
        return "role-name";
    }

    @Override
    public String getResourcePath(String resourceNameOrId, String ... resourceUrlParams) {
        if (this.isRoleId(resourceNameOrId)) {
            return super.getResourcePath(resourceNameOrId, resourceUrlParams);
        }
        String id = this.getIdForRoleNames(resourceNameOrId, this.getAsXml());
        if (id == null) {
            throw new RuntimeException("Could not find a query-roleset with roles: " + resourceNameOrId);
        }
        return this.getResourcesPath() + "/" + id;
    }

    @Override
    public boolean exists(String resourceNameOrId, String ... resourceUrlParams) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Checking for existence of resource: " + resourceNameOrId);
        }
        ResourcesFragment resourcesFragment = this.getAsXml();
        return resourcesFragment.elementExists(this.format("/node()/*[local-name(.) = 'list-items']/node()[*[local-name(.) = 'idref'] = '%s']", new Object[]{this.getIdForRoleNames(resourceNameOrId, resourcesFragment)}));
    }

    public String getIdForRoleNames(String jsonRolesArray, ResourcesFragment resourcesXml) {
        JsonNode roleArray = this.payloadParser.parseJson(jsonRolesArray);
        for (String roleId : resourcesXml.getListItemIdRefs()) {
            String myRoles = this.payloadParser.getPayloadFieldValue(this.getPropertiesAsJson(roleId, new String[0]), this.getIdFieldName());
            if (!roleArray.equals((Object)this.payloadParser.parseJson(myRoles))) continue;
            return roleId;
        }
        return null;
    }

    private boolean isRoleId(String resourceNameOrId) {
        return StringUtils.isNumeric((CharSequence)resourceNameOrId);
    }
}

