/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api.security;

import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.Resource;
import com.marklogic.mgmt.api.security.Permission;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.security.UserManager;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="user-properties")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class User
extends Resource {
    @XmlElement(name="user-name")
    private String userName;
    private String description;
    private String password;
    @XmlElementWrapper(name="external-names")
    @XmlElement(name="external-name")
    private List<String> externalName;
    @XmlElementWrapper(name="roles")
    private List<String> role;
    @XmlElementWrapper(name="permissions")
    private List<Permission> permission;
    @XmlElementWrapper(name="collections")
    private List<String> collection;

    public User() {
    }

    public User(API api, String userName) {
        super(api);
        this.userName = userName;
    }

    @Override
    protected ResourceManager getResourceManager() {
        return new UserManager(this.getClient());
    }

    @Override
    protected String getResourceId() {
        return this.userName;
    }

    public void addExternalName(String name) {
        if (this.externalName == null) {
            this.externalName = new ArrayList<String>();
        }
        this.externalName.add(name);
    }

    public void addRole(String r) {
        if (this.role == null) {
            this.role = new ArrayList<String>();
        }
        this.role.add(r);
    }

    public void addPermission(Permission p) {
        if (this.permission == null) {
            this.permission = new ArrayList<Permission>();
        }
        this.permission.add(p);
    }

    public void addCollection(String c) {
        if (this.collection == null) {
            this.collection = new ArrayList<String>();
        }
        this.collection.add(c);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<String> getExternalName() {
        return this.externalName;
    }

    public void setExternalName(List<String> externalName) {
        this.externalName = externalName;
    }

    public List<String> getRole() {
        return this.role;
    }

    public void setRole(List<String> role) {
        this.role = role;
    }

    public List<Permission> getPermission() {
        return this.permission;
    }

    public void setPermission(List<Permission> permission) {
        this.permission = permission;
    }

    public List<String> getCollection() {
        return this.collection;
    }

    public void setCollection(List<String> collection) {
        this.collection = collection;
    }
}

