/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api.security;

import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.Resource;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.security.AmpManager;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="amp-properties")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Amp
extends Resource {
    @XmlElement(name="local-name")
    private String localName;
    private String namespace;
    @XmlElement(name="document-uri")
    private String documentUri;
    @XmlElement(name="modules-database")
    private String modulesDatabase;
    @XmlElementWrapper(name="roles")
    private List<String> role;

    public Amp() {
    }

    public Amp(API api, String localName) {
        super(api);
        this.localName = localName;
    }

    @Override
    protected ResourceManager getResourceManager() {
        return new AmpManager(this.getClient());
    }

    @Override
    protected String getResourceId() {
        return this.localName;
    }

    @Override
    public String[] getResourceUrlParams() {
        return new String[]{"namespace", this.namespace, "document-uri", this.documentUri, "modules-database", this.modulesDatabase};
    }

    public void addRole(String r) {
        if (this.role == null) {
            this.role = new ArrayList<String>();
        }
        this.role.add(r);
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getDocumentUri() {
        return this.documentUri;
    }

    public void setDocumentUri(String documentUri) {
        this.documentUri = documentUri;
    }

    public String getModulesDatabase() {
        return this.modulesDatabase;
    }

    public void setModulesDatabase(String modulesDatabase) {
        this.modulesDatabase = modulesDatabase;
    }

    public List<String> getRole() {
        return this.role;
    }

    public void setRole(List<String> role) {
        this.role = role;
    }
}

