/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api.forest;

import com.marklogic.mgmt.api.API;
import com.marklogic.mgmt.api.Resource;
import com.marklogic.mgmt.api.database.ForestDatabaseReplication;
import com.marklogic.mgmt.api.forest.ForestBackup;
import com.marklogic.mgmt.api.forest.ForestReplica;
import com.marklogic.mgmt.api.forest.Range;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.forests.ForestManager;
import com.marklogic.mgmt.resource.hosts.HostManager;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="forest-properties")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Forest
extends Resource {
    @XmlElement(name="forest-name")
    private String forestName;
    private Boolean enabled;
    private String host;
    private String database;
    @XmlElement(name="data-directory")
    private String dataDirectory;
    @XmlElement(name="large-data-directory")
    private String largeDataDirectory;
    @XmlElement(name="fast-data-directory")
    private String fastDataDirectory;
    @XmlElement(name="updates-allowed")
    private String updatesAllowed;
    private String availability;
    @XmlElement(name="rebalancer-enable")
    private Boolean rebalancerEnable;
    @XmlElementWrapper(name="ranges")
    private List<Range> range;
    @XmlElement(name="failover-enable")
    private Boolean failoverEnable;
    @XmlElementWrapper(name="failover-hosts")
    @XmlElement(name="failover-host")
    private List<String> failoverHost;
    @XmlElementWrapper(name="forest-backups")
    @XmlElement(name="forest-backup")
    private List<ForestBackup> forestBackup;
    @XmlElement(name="database-replication")
    private ForestDatabaseReplication databaseReplication;
    @XmlElementWrapper(name="forest-replicas")
    @XmlElement(name="forest-replica")
    private List<ForestReplica> forestReplica;

    public Forest() {
    }

    public Forest(API api, String forestName) {
        super(api);
        this.setForestName(forestName);
    }

    public Forest(String host, String forestName) {
        this.setHost(host);
        this.setForestName(forestName);
    }

    @Override
    protected String getResourceLabel() {
        return this.getForestName();
    }

    @Override
    protected ResourceManager getResourceManager() {
        return new ForestManager(this.getClient());
    }

    @Override
    protected String getResourceId() {
        return this.forestName;
    }

    @Override
    public String save() {
        if (this.host == null) {
            String host = new HostManager(this.getClient()).getHostNames().get(0);
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info(this.format("Setting forest host to %s", host));
            }
            this.host = host;
        }
        return super.save();
    }

    public String getForestName() {
        return this.forestName;
    }

    public void setForestName(String forestName) {
        this.forestName = forestName;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public String getLargeDataDirectory() {
        return this.largeDataDirectory;
    }

    public void setLargeDataDirectory(String largeDataDirectory) {
        this.largeDataDirectory = largeDataDirectory;
    }

    public String getFastDataDirectory() {
        return this.fastDataDirectory;
    }

    public void setFastDataDirectory(String fastDataDirectory) {
        this.fastDataDirectory = fastDataDirectory;
    }

    public String getUpdatesAllowed() {
        return this.updatesAllowed;
    }

    public void setUpdatesAllowed(String updatesAllowed) {
        this.updatesAllowed = updatesAllowed;
    }

    public String getAvailability() {
        return this.availability;
    }

    public void setAvailability(String availability) {
        this.availability = availability;
    }

    public Boolean isRebalancerEnable() {
        return this.rebalancerEnable;
    }

    public void setRebalancerEnable(Boolean rebalancerEnable) {
        this.rebalancerEnable = rebalancerEnable;
    }

    public List<Range> getRange() {
        return this.range;
    }

    public void setRange(List<Range> range) {
        this.range = range;
    }

    public Boolean isFailoverEnable() {
        return this.failoverEnable;
    }

    public void setFailoverEnable(Boolean failoverEnable) {
        this.failoverEnable = failoverEnable;
    }

    public List<String> getFailoverHost() {
        return this.failoverHost;
    }

    public void setFailoverHost(List<String> failoverHost) {
        this.failoverHost = failoverHost;
    }

    public List<ForestBackup> getForestBackup() {
        return this.forestBackup;
    }

    public void setForestBackup(List<ForestBackup> forestBackup) {
        this.forestBackup = forestBackup;
    }

    public ForestDatabaseReplication getDatabaseReplication() {
        return this.databaseReplication;
    }

    public void setDatabaseReplication(ForestDatabaseReplication databaseReplication) {
        this.databaseReplication = databaseReplication;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Boolean getRebalancerEnable() {
        return this.rebalancerEnable;
    }

    public Boolean getFailoverEnable() {
        return this.failoverEnable;
    }

    public List<ForestReplica> getForestReplica() {
        return this.forestReplica;
    }

    public void setForestReplica(List<ForestReplica> forestReplica) {
        this.forestReplica = forestReplica;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }
}

