/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mgmt.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanWrapperImpl;

@JsonIgnoreProperties
public abstract class ApiObject {
    private ObjectMapper objectMapper;

    @JsonIgnore
    public List<String> getPropertyNames() {
        BeanWrapperImpl bw = new BeanWrapperImpl((Object)this);
        ArrayList<String> list = new ArrayList<String>();
        for (PropertyDescriptor pd : bw.getPropertyDescriptors()) {
            if (pd.getReadMethod() == null || pd.getWriteMethod() == null) continue;
            list.add(pd.getName());
        }
        return list;
    }

    @JsonIgnore
    public String getJson() {
        ObjectMapper mapper = this.getObjectMapper();
        if (mapper != null) {
            try {
                return mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException ex) {
                throw new RuntimeException("Unable to write object as JSON, cause: " + ex.getMessage(), ex);
            }
        }
        return null;
    }

    @JsonIgnore
    public List<String> getProps() {
        return this.getPropertyNames();
    }

    @JsonIgnore
    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

