/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.export.tasks;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.export.impl.AbstractNamedResourceExporter;
import com.marklogic.appdeployer.export.impl.ExportInputs;
import com.marklogic.appdeployer.export.tasks.TaskExportInputs;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.tasks.TaskManager;
import java.io.File;

public class TaskExporter
extends AbstractNamedResourceExporter {
    private String groupName = "Default";

    public TaskExporter(ManageClient manageClient, String ... taskNames) {
        super(manageClient, taskNames);
    }

    public TaskExporter(String groupName, ManageClient manageClient, String ... taskNames) {
        super(manageClient, taskNames);
        this.groupName = groupName;
    }

    @Override
    protected File exportToFile(ResourceManager mgr, String resourceName, File resourceDir) {
        return super.exportToFile(mgr, new TaskExportInputs(resourceName, "group-id", this.groupName), resourceDir);
    }

    @Override
    protected ResourceManager newResourceManager(ManageClient manageClient) {
        return this.groupName != null ? new TaskManager(manageClient, this.groupName) : new TaskManager(manageClient);
    }

    @Override
    protected File getResourceDirectory(File baseDir) {
        return new ConfigDir(baseDir).getTasksDir();
    }

    @Override
    protected String beforeResourceWrittenToFile(ExportInputs exportInputs, String payload) {
        return this.removeJsonKeyFromPayload(payload, "task-id");
    }
}

