/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.export.security;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.export.ExportedResources;
import com.marklogic.appdeployer.export.impl.AbstractResourceExporter;
import com.marklogic.appdeployer.export.security.AmpExportInputs;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.security.AmpManager;
import com.marklogic.rest.util.ResourcesFragment;
import java.io.File;
import java.util.ArrayList;

public class AmpExporter
extends AbstractResourceExporter {
    private String[] ampUriRefs;

    public AmpExporter(ManageClient manageClient, String ... ampUriRefs) {
        super(manageClient);
        this.ampUriRefs = ampUriRefs;
    }

    @Override
    public ExportedResources exportResources(File baseDir) {
        ArrayList<File> files = new ArrayList<File>();
        String message = null;
        if (this.ampUriRefs != null && this.ampUriRefs.length > 0) {
            AmpManager mgr = new AmpManager(this.getManageClient());
            ResourcesFragment amps = mgr.getAsXml();
            File resourceDir = new ConfigDir(baseDir).getAmpsDir();
            resourceDir.mkdirs();
            for (String ampUriRef : this.ampUriRefs) {
                String nameRef = amps.getNameRefForUriRef(ampUriRef);
                if (nameRef == null || nameRef.trim().length() == 0) {
                    this.logger.warn("Could not find amp with uriref: " + ampUriRef);
                    continue;
                }
                AmpExportInputs inputs = new AmpExportInputs(ampUriRef, nameRef, this.buildUrlParamsFromUriRef(ampUriRef));
                File f = this.exportToFile((ResourceManager)mgr, inputs, resourceDir);
                if (f == null) continue;
                files.add(f);
            }
            message = "Each amp is exported to a file named after its nameref and the hash of its uriref.";
        }
        return new ExportedResources(files, message);
    }

    protected String[] buildUrlParamsFromUriRef(String ampUriRef) {
        int pos = ampUriRef.indexOf("?");
        String qs = ampUriRef.substring(pos + 1);
        String[] params = qs.split("&");
        ArrayList<String> urlParams = new ArrayList<String>();
        for (String param : params) {
            String[] tokens = param.split("=");
            urlParams.add(tokens[0]);
            urlParams.add(tokens[1]);
        }
        return urlParams.toArray(new String[0]);
    }
}

