/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.export.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.export.ResourceExporter;
import com.marklogic.appdeployer.export.impl.ExportInputs;
import com.marklogic.appdeployer.export.impl.SimpleExportInputs;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import java.io.File;
import java.io.IOException;
import org.springframework.util.FileCopyUtils;

public abstract class AbstractResourceExporter
extends LoggingObject
implements ResourceExporter {
    private ManageClient manageClient;
    private String format = "json";
    protected PayloadParser payloadParser = new PayloadParser();
    protected ObjectMapper objectMapper;

    protected AbstractResourceExporter(ManageClient manageClient) {
        this.manageClient = manageClient;
        this.objectMapper = ObjectMapperFactory.getObjectMapper();
    }

    protected boolean isFormatXml() {
        return "xml".equalsIgnoreCase(this.getFormat());
    }

    protected String removeJsonKeyFromPayload(String payload, String key) {
        ObjectNode node;
        if (this.payloadParser.isJsonPayload(payload) && (node = (ObjectNode)this.payloadParser.parseJson(payload)).has(key)) {
            node.remove(key);
            try {
                return ObjectMapperFactory.getObjectMapper().writeValueAsString((Object)node);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Unable to write forest JSON out as string: " + e.getMessage(), e);
            }
        }
        return payload;
    }

    protected File exportToFile(ResourceManager mgr, String resourceName, File resourceDir) {
        return this.exportToFile(mgr, new SimpleExportInputs(resourceName, new String[0]), resourceDir);
    }

    protected File exportToFile(ResourceManager mgr, ExportInputs exportInputs, File resourceDir) {
        File f = null;
        try {
            f = this.isFormatXml() ? this.exportToXml(mgr, exportInputs, resourceDir) : this.exportToJson(mgr, exportInputs, resourceDir);
        }
        catch (IOException ex) {
            this.logger.warn(this.format("Unable to export resource with name %s to resource directory %s, cause: %s", new Object[]{exportInputs.getResourceName(), resourceDir.getAbsolutePath(), ex.getMessage()}), (Throwable)ex);
        }
        return f;
    }

    protected File exportToXml(ResourceManager mgr, ExportInputs exportInputs, File resourceDir) throws IOException {
        String xml = mgr.getPropertiesAsXmlString(exportInputs.getResourceName(), exportInputs.getResourceUrlParams());
        xml = this.beforeResourceWrittenToFile(exportInputs, xml);
        File f = new File(resourceDir, exportInputs.buildFilename("xml"));
        this.logWritingFile(exportInputs, f);
        FileCopyUtils.copy((byte[])xml.getBytes(), (File)f);
        return f;
    }

    protected File exportToJson(ResourceManager mgr, ExportInputs exportInputs, File resourceDir) throws IOException {
        String json = mgr.getPropertiesAsJson(exportInputs.getResourceName(), exportInputs.getResourceUrlParams());
        json = this.beforeResourceWrittenToFile(exportInputs, json);
        json = this.prettyPrintJson(json);
        File f = new File(resourceDir, exportInputs.buildFilename("json"));
        this.logWritingFile(exportInputs, f);
        FileCopyUtils.copy((byte[])json.getBytes(), (File)f);
        return f;
    }

    protected String prettyPrintJson(String json) throws IOException {
        JsonNode node = this.objectMapper.readTree(json);
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
    }

    protected String beforeResourceWrittenToFile(ExportInputs exportInputs, String payload) {
        return payload;
    }

    protected void logWritingFile(ExportInputs exportInputs, File file) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Exporting resource %s to file %s", new Object[]{exportInputs.getResourceName(), file.getAbsolutePath()}));
        }
    }

    public ManageClient getManageClient() {
        return this.manageClient;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

