/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.security;

import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.resource.security.CertificateTemplateManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.util.FileCopyUtils;

public class InsertCertificateHostsTemplateCommand
extends AbstractCommand {
    private String publicCertificateFileExtension = ".crt";
    private String privateKeyFileExtension = ".key";

    public InsertCertificateHostsTemplateCommand() {
        this.setExecuteSortOrder(SortOrderConstants.INSERT_HOST_CERTIFICATES);
    }

    @Override
    public void execute(CommandContext context) {
        List<String> templateNames = new CertificateTemplateManager(context.getManageClient()).getAsXml().getListItemNameRefs();
        if (templateNames != null && !templateNames.isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Looking for host certificates to insert for certificate templates: " + templateNames);
            }
            for (String templateName : templateNames) {
                this.insertHostCertificatesForTemplate(context, templateName);
            }
        }
    }

    protected void insertHostCertificatesForTemplate(CommandContext context, String templateName) {
        for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            File hostCertDir = new File(configDir.getCertificateTemplatesDir() + File.separator + "host-certificates" + File.separator + templateName);
            this.logger.info(this.format("Looking for host certificate files ending in '%s' for template '%s' in: %s", new Object[]{this.publicCertificateFileExtension, templateName, hostCertDir.getAbsolutePath()}));
            if (!hostCertDir.exists()) continue;
            for (File f : hostCertDir.listFiles()) {
                if (!f.getName().endsWith(this.publicCertificateFileExtension)) continue;
                File privateKeyFile = this.determinePrivateKeyFile(f);
                if (privateKeyFile.exists()) {
                    this.logger.info("Found public certificate file at: " + f.getAbsolutePath() + ", and found corresponding private key file at: " + privateKeyFile.getAbsolutePath());
                    this.insertHostCertificate(context, templateName, f, privateKeyFile);
                    continue;
                }
                this.logger.warn("Did not find expected private key file at: " + privateKeyFile.getAbsolutePath() + "; will ignore public certificate file found at: " + f.getAbsolutePath());
            }
        }
    }

    protected File determinePrivateKeyFile(File publicCertificateFile) {
        String path = publicCertificateFile.getAbsolutePath();
        return new File(path.substring(0, path.length() - this.publicCertificateFileExtension.length()) + this.privateKeyFileExtension);
    }

    protected void insertHostCertificate(CommandContext context, String templateName, File publicCertFile, File privateKeyFile) {
        if (!this.certificateExists(templateName, publicCertFile, context.getManageClient())) {
            this.logger.info(this.format("Inserting host certificate for certificate template '%s'", new Object[]{templateName}));
            String pubCertString = this.copyFileToString(publicCertFile);
            String privateKeyString = this.copyFileToString(privateKeyFile);
            new CertificateTemplateManager(context.getManageClient()).insertHostCertificate(templateName, pubCertString, privateKeyString);
            this.logger.info(this.format("Inserted host certificate for certificate template '%s'", new Object[]{templateName}));
        } else {
            this.logger.info(this.format("Host certificate already exists for certificate template '%s', so not inserting host certificate found at: %s", new Object[]{templateName, publicCertFile.getAbsolutePath()}));
        }
    }

    protected boolean certificateExists(String templateName, File publicCertFile, ManageClient manageClient) {
        CertificateTemplateManager mgr = new CertificateTemplateManager(manageClient);
        String hostName = null;
        try {
            hostName = this.getCertificateHostName(publicCertFile, manageClient);
        }
        catch (Exception ex) {
            this.logger.warn("Unable to determine host name for public certificate file: " + publicCertFile + "; cause: " + ex.getMessage() + ". Due to this, the check to determine if the certificate exists already will not include a host name but will only be based on the name of the template.");
        }
        if (hostName != null) {
            this.logger.info(this.format("Checking for existing certificate with name '%s' and host name '%s'", new Object[]{templateName, hostName}));
            return mgr.certificateExists(templateName, hostName);
        }
        this.logger.info(this.format("Could not determine host name, so checking for existing certificate with name '%s'", new Object[]{templateName}));
        return mgr.certificateExists(templateName);
    }

    protected String getCertificateHostName(File publicCertFile, ManageClient manageClient) {
        String query = this.makeQueryForHostName(publicCertFile);
        String response = (String)manageClient.postForm("/v1/eval", "xquery", query).getBody();
        return this.extractHostNameFromEvalResponse(response);
    }

    protected String makeQueryForHostName(File publicCertFile) {
        String certContents;
        try {
            certContents = new String(FileCopyUtils.copyToByteArray((File)publicCertFile));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read certificate from file: " + publicCertFile + "; cause: " + e.getMessage());
        }
        return this.format("xdmp:x509-certificate-extract(\"%s\")/*:subject/*:commonName/fn:string()", new Object[]{certContents});
    }

    protected String extractHostNameFromEvalResponse(String response) {
        String token = "X-Primitive: string";
        int pos = response.indexOf("X-Primitive: string");
        if (pos < 0) {
            throw new IllegalArgumentException("Unable to extract host name from eval response: " + response + "; did not find: " + "X-Primitive: string");
        }
        if ((pos = (response = response.substring(pos + "X-Primitive: string".length()).trim()).indexOf("--")) < 0) {
            throw new IllegalArgumentException("Unable to extract host name from eval response: " + response + "; did not find '--' after " + "X-Primitive: string");
        }
        return response.substring(0, pos).trim();
    }

    public void setPublicCertificateFileExtension(String publicCertificateFileExtension) {
        this.publicCertificateFileExtension = publicCertificateFileExtension;
    }

    public void setPrivateKeyFileExtension(String privateKeyFileExtension) {
        this.privateKeyFileExtension = privateKeyFileExtension;
    }
}

