/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.security;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.ResourceReference;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.appdeployer.command.SupportsCmaCommand;
import com.marklogic.appdeployer.command.security.PrivilegeBiPredicate;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.api.security.Privilege;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.security.PrivilegeManager;
import java.io.File;
import java.util.function.BiPredicate;

public class DeployPrivilegesCommand
extends AbstractResourceCommand
implements SupportsCmaCommand {
    private boolean removeRolesBeforeSaving = true;

    public DeployPrivilegesCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_PRIVILEGES);
        this.setUndoSortOrder(SortOrderConstants.DELETE_PRIVILEGES);
        this.setSupportsResourceMerging(true);
        this.setResourceClassType(Privilege.class);
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return this.findResourceDirs(context, (ConfigDir configDir) -> configDir.getPrivilegesDir());
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return new PrivilegeManager(context.getManageClient());
    }

    @Override
    protected String adjustPayloadBeforeSavingResource(CommandContext context, File f, String payload) {
        payload = super.adjustPayloadBeforeSavingResource(context, f, payload);
        return this.removeRolesBeforeSaving ? new PayloadParser().excludeProperties(payload, "role") : payload;
    }

    @Override
    public boolean cmaShouldBeUsed(CommandContext context) {
        return context.getAppConfig().getCmaConfig().isDeployPrivileges();
    }

    @Override
    public void addResourceToConfiguration(ObjectNode resource, Configuration configuration) {
        if (this.removeRolesBeforeSaving && resource != null && resource.has("role")) {
            resource.remove("role");
        }
        configuration.addPrivilege(resource);
    }

    @Override
    protected void deployConfiguration(CommandContext context, Configuration config) {
        if (context.getAppConfig().getCmaConfig().isCombineRequests()) {
            this.logger.info("Adding privileges to combined CMA request");
            context.addCmaConfigurationToCombinedRequest(config);
        } else {
            super.deployConfiguration(context, config);
        }
    }

    @Override
    protected BiPredicate<ResourceReference, ResourceReference> getBiPredicateForMergingResources() {
        return new PrivilegeBiPredicate();
    }

    public boolean isRemoveRolesBeforeSaving() {
        return this.removeRolesBeforeSaving;
    }

    public void setRemoveRolesBeforeSaving(boolean removeRolesBeforeSaving) {
        this.removeRolesBeforeSaving = removeRolesBeforeSaving;
    }
}

