/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.forests;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.PayloadParser;
import com.marklogic.mgmt.api.configuration.Configuration;
import com.marklogic.mgmt.resource.forests.ForestManager;
import java.io.File;
import java.util.Iterator;

public class DeployCustomForestsCommand
extends AbstractCommand {
    private String customForestsPath = "forests";
    private PayloadParser payloadParser;

    public DeployCustomForestsCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_FORESTS);
    }

    @Override
    public void execute(CommandContext context) {
        for (ConfigDir configDir : context.getAppConfig().getConfigDirs()) {
            File dir = new File(configDir.getBaseDir(), this.customForestsPath);
            if (dir != null && dir.exists()) {
                this.payloadParser = new PayloadParser();
                for (File f : dir.listFiles()) {
                    if (!f.isDirectory()) continue;
                    this.processDirectory(f, context);
                }
                continue;
            }
            this.logResourceDirectoryNotFound(dir);
        }
    }

    protected void processDirectory(File dir, CommandContext context) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Processing custom forest files in directory: " + dir.getAbsolutePath());
        }
        ForestManager mgr = new ForestManager(context.getManageClient());
        for (File f : this.listFilesInDirectory(dir)) {
            Configuration configuration;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Processing forests in file: " + f.getAbsolutePath());
            }
            String payload = this.readResourceFromFile(context, f);
            Configuration configuration2 = configuration = context.getAppConfig().getCmaConfig().isDeployForests() ? new Configuration() : null;
            if (this.payloadParser.isJsonPayload(payload)) {
                if (configuration != null) {
                    this.addForestsToCmaConfiguration(context, payload, configuration);
                } else {
                    mgr.saveJsonForests(payload);
                }
            } else if (configuration != null) {
                configuration.addForest(this.convertPayloadToObjectNode(context, payload));
            } else {
                mgr.save(payload);
            }
            if (configuration == null) continue;
            this.deployConfiguration(context, configuration);
        }
    }

    protected void addForestsToCmaConfiguration(CommandContext context, String payload, Configuration configuration) {
        JsonNode node = this.payloadParser.parseJson(payload);
        if (node.isArray()) {
            Iterator iter = node.iterator();
            while (iter.hasNext()) {
                configuration.addForest((ObjectNode)iter.next());
            }
        } else {
            configuration.addForest((ObjectNode)node);
        }
    }

    public void setCustomForestsPath(String customForestsPath) {
        this.customForestsPath = customForestsPath;
    }
}

