/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.forests;

import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.forests.ForestHostNames;
import com.marklogic.appdeployer.command.forests.HostCalculator;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.mgmt.api.forest.Forest;
import com.marklogic.mgmt.resource.hosts.HostNameProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultHostCalculator
extends LoggingObject
implements HostCalculator {
    private HostNameProvider hostNameProvider;

    public DefaultHostCalculator(HostNameProvider hostNameProvider) {
        this.hostNameProvider = hostNameProvider;
    }

    @Override
    public ForestHostNames calculateHostNames(String databaseName, CommandContext context, List<Forest> existingPrimaryForests) {
        List<String> candidateHostNames = this.getCandidateHostNames(databaseName, context);
        if (candidateHostNames.isEmpty()) {
            throw new RuntimeException("Unable to determine host names for forests for database: " + databaseName + "; please check the properties you've set for creating forests for this database to ensure that forests can be created on at least one host in your cluster");
        }
        ArrayList<String> primaryForestHostNames = new ArrayList<String>();
        ArrayList<String> replicaForestHostNames = new ArrayList<String>();
        if (context.getAppConfig().isDatabaseWithForestsOnOneHost(databaseName)) {
            if (existingPrimaryForests.size() > 0) {
                primaryForestHostNames.add(existingPrimaryForests.get(0).getHost());
                replicaForestHostNames.addAll(candidateHostNames);
            } else {
                primaryForestHostNames.add(candidateHostNames.get(0));
                replicaForestHostNames.addAll(candidateHostNames);
            }
        } else {
            primaryForestHostNames.addAll(candidateHostNames);
            replicaForestHostNames.addAll(candidateHostNames);
        }
        return new ForestHostNames(primaryForestHostNames, replicaForestHostNames);
    }

    protected List<String> getCandidateHostNames(String databaseName, CommandContext context) {
        List<String> hostNamesFromDatabaseGroups;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Finding eligible hosts for forests for database: " + databaseName);
        }
        if ((hostNamesFromDatabaseGroups = this.determineHostNamesBasedOnDatabaseGroups(databaseName, context)) != null) {
            return hostNamesFromDatabaseGroups;
        }
        List<String> hostNames = this.hostNameProvider.getHostNames();
        List<String> hostNamesFromDatabaseHosts = this.determineHostNamesBasedOnDatabaseHosts(databaseName, context, hostNames);
        if (hostNamesFromDatabaseHosts != null) {
            return hostNamesFromDatabaseHosts;
        }
        return hostNames;
    }

    protected List<String> determineHostNamesBasedOnDatabaseGroups(String databaseName, CommandContext context) {
        List<String> selectedGroupNames;
        Map<String, List<String>> databaseGroups = context.getAppConfig().getDatabaseGroups();
        if (databaseGroups != null && (selectedGroupNames = databaseGroups.get(databaseName)) != null) {
            List<String> set;
            ArrayList<String> selectedHostNames = new ArrayList<String>();
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.format("Creating forests on hosts in groups %s for database '%s'", new Object[]{selectedGroupNames, databaseName}));
            }
            for (String groupName : selectedGroupNames) {
                List<String> groupHostNames = this.hostNameProvider.getGroupHostNames(groupName);
                if (groupHostNames != null && !groupHostNames.isEmpty()) {
                    for (String hostName : groupHostNames) {
                        if (selectedHostNames.contains(hostName)) continue;
                        selectedHostNames.add(hostName);
                    }
                    continue;
                }
                this.logger.warn("No hosts found for group: " + groupName);
            }
            Map<String, List<String>> databaseHosts = context.getAppConfig().getDatabaseHosts();
            if (databaseHosts != null && (set = databaseHosts.get(databaseName)) != null && !set.isEmpty()) {
                this.logger.warn(this.format("Database groups and database hosts were both specified for database '%s'; only database groups are being used, database hosts will be ignored.", new Object[]{databaseName}));
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.format("Creating forests on hosts %s based on groups %s for database '%s'", new Object[]{selectedHostNames, selectedGroupNames, databaseName}));
            }
            return selectedHostNames;
        }
        return null;
    }

    protected List<String> determineHostNamesBasedOnDatabaseHosts(String databaseName, CommandContext context, List<String> hostNames) {
        List<String> databaseHostNames;
        Map<String, List<String>> databaseHosts = context.getAppConfig().getDatabaseHosts();
        if (databaseHosts != null && (databaseHostNames = databaseHosts.get(databaseName)) != null) {
            ArrayList<String> selectedHostNames = new ArrayList<String>();
            for (String name : databaseHostNames) {
                if (hostNames.contains(name)) {
                    selectedHostNames.add(name);
                    continue;
                }
                this.logger.warn(this.format("Host '%s' for database '%s' is not recognized, ignoring", new Object[]{name, databaseName}));
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.format("Creating forests for database '%s' on hosts: %s", new Object[]{databaseName, selectedHostNames}));
            }
            return selectedHostNames;
        }
        return null;
    }
}

