/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command.alert;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.ConfigDir;
import com.marklogic.appdeployer.command.AbstractResourceCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.SortOrderConstants;
import com.marklogic.mgmt.resource.ResourceManager;
import com.marklogic.mgmt.resource.alert.AlertConfigManager;
import java.io.File;

public class DeployAlertConfigsCommand
extends AbstractResourceCommand {
    private AlertConfigManager currentAlertConfigManager;

    public DeployAlertConfigsCommand() {
        this.setExecuteSortOrder(SortOrderConstants.DEPLOY_ALERT_CONFIGS);
        this.setDeleteResourcesOnUndo(false);
    }

    @Override
    public void execute(CommandContext context) {
        AppConfig appConfig = context.getAppConfig();
        for (ConfigDir configDir : appConfig.getConfigDirs()) {
            this.deployAlertConfigs(context, configDir, appConfig.getContentDatabaseName());
            for (File dir : configDir.getDatabaseResourceDirectories()) {
                String databaseName = this.determineDatabaseNameForDatabaseResourceDirectory(context, configDir, dir);
                if (databaseName == null) continue;
                this.deployAlertConfigs(context, new ConfigDir(dir), databaseName);
            }
        }
    }

    protected void deployAlertConfigs(CommandContext context, ConfigDir configDir, String databaseIdOrName) {
        this.currentAlertConfigManager = new AlertConfigManager(context.getManageClient(), databaseIdOrName);
        this.processExecuteOnResourceDir(context, configDir.getAlertConfigsDir());
    }

    @Override
    protected File[] getResourceDirs(CommandContext context) {
        return null;
    }

    @Override
    protected ResourceManager getResourceManager(CommandContext context) {
        return this.currentAlertConfigManager;
    }
}

